/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb;

import io.github.InsiderAnh.xPlayerKits.libs.bson.types.ObjectId;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteRequestBuilder;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBCollection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObject;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.InsertRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteConcern;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteRequest;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.List;

public class BulkWriteOperation {
    private static final String ID_FIELD_NAME = "_id";
    private final boolean ordered;
    private final DBCollection collection;
    private final List<WriteRequest> requests = new ArrayList<WriteRequest>();
    private Boolean bypassDocumentValidation;
    private boolean closed;

    BulkWriteOperation(boolean ordered, DBCollection collection) {
        this.ordered = ordered;
        this.collection = collection;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public void setBypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    public void insert(DBObject document) {
        Assertions.isTrue("already executed", !this.closed);
        if (document.get(ID_FIELD_NAME) == null) {
            document.put(ID_FIELD_NAME, new ObjectId());
        }
        this.addRequest(new InsertRequest(document, this.collection.getObjectCodec()));
    }

    public BulkWriteRequestBuilder find(DBObject query) {
        Assertions.isTrue("already executed", !this.closed);
        return new BulkWriteRequestBuilder(this, query, this.collection.getDefaultDBObjectCodec(), this.collection.getObjectCodec());
    }

    public BulkWriteResult execute() {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.bypassDocumentValidation, this.requests);
    }

    public BulkWriteResult execute(WriteConcern writeConcern) {
        Assertions.isTrue("already executed", !this.closed);
        this.closed = true;
        return this.collection.executeBulkWriteOperation(this.ordered, this.bypassDocumentValidation, this.requests, writeConcern);
    }

    void addRequest(WriteRequest request) {
        Assertions.isTrue("already executed", !this.closed);
        this.requests.add(request);
    }
}

