/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.mongodb;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocument;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonDocumentReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.AcknowledgedBulkWriteResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteUpsert;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObject;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.DBObjects;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.MongoBulkWriteException;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.UnacknowledgedBulkWriteResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.BulkWriteError;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.BulkWriteResult;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.WriteConcernError;
import java.util.ArrayList;
import java.util.List;

final class BulkWriteHelper {
    static io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteResult translateBulkWriteResult(BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<BulkWriteUpsert> translateBulkWriteUpserts(List<io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<BulkWriteUpsert> retVal = new ArrayList<BulkWriteUpsert>(upserts.size());
        for (io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.BulkWriteUpsert cur : upserts) {
            retVal.add(new BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(io.github.InsiderAnh.xPlayerKits.libs.mongodb.bulk.BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteConcernError translateWriteConcernError(WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new io.github.InsiderAnh.xPlayerKits.libs.mongodb.WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteError> translateWriteErrors(List<BulkWriteError> errors) {
        ArrayList<io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteError> retVal = new ArrayList<io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteError>(errors.size());
        for (BulkWriteError cur : errors) {
            retVal.add(new io.github.InsiderAnh.xPlayerKits.libs.mongodb.BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

