/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.bson.diagnostics;

import io.github.InsiderAnh.xPlayerKits.libs.bson.assertions.Assertions;
import io.github.InsiderAnh.xPlayerKits.libs.bson.diagnostics.JULLogger;
import io.github.InsiderAnh.xPlayerKits.libs.bson.diagnostics.Logger;
import io.github.InsiderAnh.xPlayerKits.libs.bson.diagnostics.SLF4JLogger;

public final class Loggers {
    public static final String PREFIX = "io.github.InsiderAnh.xPlayerKits.libs.bson";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (suffix.startsWith(".") || suffix.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String name = "io.github.InsiderAnh.xPlayerKits.libs.bson." + suffix;
        if (USE_SLF4J) {
            return new SLF4JLogger(name);
        }
        return new JULLogger(name);
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Loggers() {
    }
}

