/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo;

import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Codec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.configuration.CodecRegistry;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.CollectionPropertyCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.EnumPropertyCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.FallbackPropertyCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.MapPropertyCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.PojoCodec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.PropertyCodecProvider;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.PropertyCodecRegistry;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.pojo.TypeWithTypeParameters;
import java.util.ArrayList;
import java.util.List;

class PropertyCodecRegistryImpl
implements PropertyCodecRegistry {
    private final List<PropertyCodecProvider> propertyCodecProviders;

    PropertyCodecRegistryImpl(PojoCodec<?> pojoCodec, CodecRegistry codecRegistry, List<PropertyCodecProvider> propertyCodecProviders) {
        ArrayList<PropertyCodecProvider> augmentedProviders = new ArrayList<PropertyCodecProvider>();
        if (propertyCodecProviders != null) {
            augmentedProviders.addAll(propertyCodecProviders);
        }
        augmentedProviders.add(new CollectionPropertyCodecProvider());
        augmentedProviders.add(new MapPropertyCodecProvider());
        augmentedProviders.add(new EnumPropertyCodecProvider(codecRegistry));
        augmentedProviders.add(new FallbackPropertyCodecProvider(pojoCodec, codecRegistry));
        this.propertyCodecProviders = augmentedProviders;
    }

    public <S> Codec<S> get(TypeWithTypeParameters<S> type) {
        for (PropertyCodecProvider propertyCodecProvider : this.propertyCodecProviders) {
            Codec<S> codec = propertyCodecProvider.get(type, this);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }
}

