/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.jsr310;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.configuration.CodecConfigurationException;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.jsr310.DateTimeBasedCodec;
import java.time.Instant;

public class InstantCodec
extends DateTimeBasedCodec<Instant> {
    @Override
    public Instant decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader));
    }

    @Override
    public void encode(BsonWriter writer, Instant value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported Instant value '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }
}

