/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.libs.bson.codecs;

import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonInvalidOperationException;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonReader;
import io.github.InsiderAnh.xPlayerKits.libs.bson.BsonWriter;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.Codec;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.EncoderContext;
import io.github.InsiderAnh.xPlayerKits.libs.bson.codecs.NumberCodecHelper;

public class ShortCodec
implements Codec<Short> {
    @Override
    public void encode(BsonWriter writer, Short value, EncoderContext encoderContext) {
        writer.writeInt32(value.shortValue());
    }

    @Override
    public Short decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Short.", value));
        }
        return (short)value;
    }

    @Override
    public Class<Short> getEncoderClass() {
        return Short.class;
    }
}

