/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.kits;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.utils.InventorySerializable;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class Kit {
    private final ArrayList<String> requirements = new ArrayList();
    private final HashMap<String, ItemStack> icons = new HashMap();
    private final ArrayList<String> actionsOnClaim = new ArrayList();
    private final ArrayList<String> actionsOnDeny = new ArrayList();
    private String name;
    private long countdown;
    private boolean oneTime;
    private boolean autoArmor;
    private boolean preview;
    private boolean checkInventorySpace;
    private int slot;
    private int page;
    private double price;
    private String permission;
    private ItemStack[] armor = new ItemStack[10];
    private ItemStack[] inventory = new ItemStack[50];
    private ItemStack offhand;

    public Kit(String name, int slot) {
        this.name = name;
        this.countdown = TimeUnit.MINUTES.toSeconds(5L);
        this.oneTime = false;
        this.autoArmor = false;
        this.preview = false;
        this.checkInventorySpace = true;
        this.slot = slot;
        this.page = 1;
        this.price = 0.0;
        this.permission = "none";
        this.armor = new ItemStack[10];
        this.inventory = new ItemStack[50];
        this.offhand = null;
        this.requirements.add("none");
        this.actionsOnClaim.add("console:say Test allow commands.");
        this.actionsOnClaim.add("command:/test command");
        this.actionsOnClaim.add("sound:ENTITY_PLAYER_LEVELUP;1.0f;1.0f");
        this.actionsOnDeny.add("console:say Test allow commands.");
        this.actionsOnDeny.add("command:/test command");
        this.actionsOnDeny.add("sound:ENTITY_ENDERMAN_TELEPORT;1.0f;1.0f");
        this.icons.put("CAN_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim!").build());
        this.icons.put("CANT_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou can\u00b4t claim this kit!").build());
        this.icons.put("NO_PERMISSION", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou don\u00b4t have permission!").build());
        this.icons.put("COUNTDOWN", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cIn countdown!").build());
        this.icons.put("ONE_TIME_CLAIMED", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cAlready claimed!").build());
        this.icons.put("ONE_TIME_REQUIREMENT", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim one time!").build());
    }

    public Kit(@NotNull InsiderConfig config) {
        this.name = config.getString("name");
        this.countdown = config.getLong("countdown");
        this.oneTime = config.getBoolean("oneTime");
        this.autoArmor = config.getBoolean("autoArmor");
        this.preview = config.getBooleanOrDefault("preview", true);
        this.checkInventorySpace = config.getBooleanOrDefault("checkInventorySpace", true);
        this.slot = config.getInt("slot");
        this.page = config.getInt("page");
        this.price = config.getDouble("price");
        this.permission = config.getString("permission");
        this.requirements.addAll(config.getList("requirements"));
        this.actionsOnClaim.addAll(config.getList("actionsOnClaim"));
        this.actionsOnDeny.addAll(config.getList("actionsOnDeny"));
        if (config.isSet("armor")) {
            this.armor = InventorySerializable.itemStackArrayFromBase64(config.getString("armor"));
            this.inventory = InventorySerializable.itemStackArrayFromBase64(config.getString("inventory"));
            if (config.isSet("icons")) {
                for (String key : config.getConfig().getConfigurationSection("icons").getKeys(false)) {
                    this.icons.put(key, InventorySerializable.itemStackFromBase64(config.getConfig().getString("icons." + key)));
                }
            }
            this.save();
        }
        if (config.isSet("armorSet")) {
            for (String key : config.getConfig().getConfigurationSection("armorSet").getKeys(false)) {
                this.armor[Integer.parseInt((String)key)] = config.getConfig().getItemStack("armorSet." + key);
            }
        }
        if (config.isSet("inventorySet")) {
            for (String key : config.getConfig().getConfigurationSection("inventorySet").getKeys(false)) {
                this.inventory[Integer.parseInt((String)key)] = config.getConfig().getItemStack("inventorySet." + key);
            }
        }
        if (config.isSet("iconSet")) {
            for (String key : config.getConfig().getConfigurationSection("iconSet").getKeys(false)) {
                this.icons.put(key, config.getConfig().getItemStack("iconSet." + key));
            }
        }
        if (config.isSet("offhand")) {
            this.offhand = config.getConfig().getItemStack("offhand");
        }
    }

    public void save() {
        ItemStack itemStack;
        int i;
        InsiderConfig config = new InsiderConfig(PlayerKits.getInstance(), "kits/" + this.name, false, false);
        config.set("armorSet", null);
        config.set("inventorySet", null);
        config.set("iconSet", null);
        config.set("offhand", null);
        config.set("name", this.name);
        config.set("countdown", this.countdown);
        config.set("oneTime", this.oneTime);
        config.set("autoArmor", this.autoArmor);
        config.set("preview", this.preview);
        config.set("checkInventorySpace", this.checkInventorySpace);
        config.set("slot", this.slot);
        config.set("page", this.page);
        config.set("price", this.price);
        config.set("permission", this.permission);
        config.set("requirements", this.requirements);
        config.set("actionsOnClaim", this.actionsOnClaim);
        config.set("actionsOnDeny", this.actionsOnDeny);
        if (this.offhand != null) {
            config.set("offhand", this.offhand);
        }
        for (i = 0; i < this.armor.length; ++i) {
            itemStack = this.armor[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            config.set("armorSet." + i, itemStack);
        }
        for (i = 0; i < this.inventory.length; ++i) {
            itemStack = this.inventory[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            config.set("inventorySet." + i, itemStack);
        }
        for (String key : this.icons.keySet()) {
            config.set("iconSet." + key, this.icons.get(key));
        }
        config.set("armor", null);
        config.set("inventory", null);
        config.set("icons", null);
        config.save();
    }

    public boolean isNoInventorySpace(Player player) {
        ItemStack toItem;
        ItemStack itemStack;
        int i;
        AtomicBoolean occupied = new AtomicBoolean(false);
        PlayerInventory playerInv = player.getInventory();
        for (i = 0; i < this.inventory.length; ++i) {
            itemStack = this.inventory[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || (toItem = playerInv.getItem(i)) == null || toItem.getType().name().equals("AIR") || toItem.getType().name().equals("VOID_AIR") || toItem.getType().name().equals("CAVE_AIR")) continue;
            occupied.set(true);
        }
        for (i = 0; i < this.armor.length; ++i) {
            itemStack = this.armor[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || (toItem = player.getInventory().getArmorContents()[i]) == null || toItem.getType().name().equals("AIR") || toItem.getType().name().equals("VOID_AIR") || toItem.getType().name().equals("CAVE_AIR")) continue;
            occupied.set(true);
        }
        return occupied.get();
    }

    public void giveKit(Player player) {
        ItemStack toItem;
        ItemStack itemStack;
        int i;
        XPKUtils.executeActions(player, this.actionsOnClaim);
        PlayerInventory playerInv = player.getInventory();
        for (i = 0; i < this.inventory.length; ++i) {
            itemStack = this.inventory[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || (toItem = playerInv.getItem(i)) != null && !toItem.getType().equals((Object)Material.AIR)) continue;
            playerInv.setItem(i, itemStack);
        }
        for (i = 0; i < this.armor.length; ++i) {
            itemStack = this.armor[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || (toItem = player.getInventory().getArmorContents()[i]) != null && !toItem.getType().equals((Object)Material.AIR)) continue;
            if (XPKUtils.isHelmet(itemStack.getType().name())) {
                player.getInventory().setHelmet(itemStack);
            }
            if (XPKUtils.isChestplate(itemStack.getType().name())) {
                player.getInventory().setChestplate(itemStack);
            }
            if (XPKUtils.isLeggings(itemStack.getType().name())) {
                player.getInventory().setLeggings(itemStack);
            }
            if (!XPKUtils.isBoots(itemStack.getType().name())) continue;
            player.getInventory().setBoots(itemStack);
        }
    }

    public boolean isNoHasRequirements(Player player) {
        for (String requirement : this.requirements) {
            if (requirement.equalsIgnoreCase("none") || XPKUtils.passCondition(player, requirement)) continue;
            return true;
        }
        return false;
    }

    public String getRequirementsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String requirement : this.requirements) {
            stringBuilder.append(requirement).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getActionsOnClaimString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String command : this.actionsOnClaim) {
            stringBuilder.append(command).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getActionsOnDenyString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String command : this.actionsOnDeny) {
            stringBuilder.append(command).append("\n");
        }
        return stringBuilder.toString();
    }

    @Generated
    public ArrayList<String> getRequirements() {
        return this.requirements;
    }

    @Generated
    public HashMap<String, ItemStack> getIcons() {
        return this.icons;
    }

    @Generated
    public ArrayList<String> getActionsOnClaim() {
        return this.actionsOnClaim;
    }

    @Generated
    public ArrayList<String> getActionsOnDeny() {
        return this.actionsOnDeny;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getCountdown() {
        return this.countdown;
    }

    @Generated
    public boolean isOneTime() {
        return this.oneTime;
    }

    @Generated
    public boolean isAutoArmor() {
        return this.autoArmor;
    }

    @Generated
    public boolean isPreview() {
        return this.preview;
    }

    @Generated
    public boolean isCheckInventorySpace() {
        return this.checkInventorySpace;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public ItemStack[] getArmor() {
        return this.armor;
    }

    @Generated
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Generated
    public ItemStack getOffhand() {
        return this.offhand;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCountdown(long countdown) {
        this.countdown = countdown;
    }

    @Generated
    public void setOneTime(boolean oneTime) {
        this.oneTime = oneTime;
    }

    @Generated
    public void setAutoArmor(boolean autoArmor) {
        this.autoArmor = autoArmor;
    }

    @Generated
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    @Generated
    public void setCheckInventorySpace(boolean checkInventorySpace) {
        this.checkInventorySpace = checkInventorySpace;
    }

    @Generated
    public void setSlot(int slot) {
        this.slot = slot;
    }

    @Generated
    public void setPage(int page) {
        this.page = page;
    }

    @Generated
    public void setPrice(double price) {
        this.price = price;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setArmor(ItemStack[] armor) {
        this.armor = armor;
    }

    @Generated
    public void setInventory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    @Generated
    public void setOffhand(ItemStack offhand) {
        this.offhand = offhand;
    }
}

