/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.inventory;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class AInventory
implements Listener {
    private final Player player;
    private final Inventory inventory;
    private final boolean update;

    public AInventory(Player player, InventorySizes invSizes, String name) {
        this(player, invSizes, name, true);
    }

    public AInventory(Player player, InventorySizes invSizes, String name, boolean update) {
        this.player = player;
        this.inventory = Bukkit.createInventory(null, (int)invSizes.toInv(), (String)XPKUtils.color(name));
        this.update = update;
    }

    @EventHandler
    public void onClickEvent(InventoryClickEvent event) {
        if (!event.getWhoClicked().getName().equalsIgnoreCase(this.player.getName()) || event.getSlotType().equals((Object)InventoryType.SlotType.OUTSIDE)) {
            return;
        }
        if (event.getView().getTopInventory().equals(this.inventory)) {
            if (event.getView().getBottomInventory().equals(event.getClickedInventory())) {
                this.onBottom(event, event.getCurrentItem(), event.getClick(), arg_0 -> ((InventoryClickEvent)event).setCancelled(arg_0));
                return;
            }
            if (event.getCurrentItem() != null && !event.getCurrentItem().getType().equals((Object)Material.AIR)) {
                this.onClick(event, event.getCurrentItem(), event.getClick(), arg_0 -> ((InventoryClickEvent)event).setCancelled(arg_0));
            } else if (event.getCurrentItem() != null) {
                this.onDrag(event, event.getCurrentItem(), event.getClick(), arg_0 -> ((InventoryClickEvent)event).setCancelled(arg_0));
            } else {
                this.onAllClick(event, event.getCurrentItem(), event.getClick(), arg_0 -> ((InventoryClickEvent)event).setCancelled(arg_0));
            }
        }
    }

    @EventHandler
    public void onCloseEvent(InventoryCloseEvent event) {
        if (!event.getPlayer().equals(this.player)) {
            return;
        }
        if (event.getInventory().equals(this.inventory)) {
            this.onClose();
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (event.getInventory().equals(this.inventory)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(InventoryMoveItemEvent event) {
        if (event.getDestination().equals(this.inventory)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(InventoryPickupItemEvent event) {
        if (event.getInventory().equals(this.inventory)) {
            event.setCancelled(true);
        }
    }

    protected abstract void onClick(InventoryClickEvent var1, ItemStack var2, ClickType var3, Consumer<Boolean> var4);

    protected void onBottom(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
    }

    protected abstract void onUpdate(Inventory var1);

    protected void onDrag(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
    }

    protected void onAllClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
    }

    protected void set(int x, int y, ItemStack itemStack) {
        int slot = y * 9 + x;
        this.inventory.setItem(slot, itemStack);
    }

    protected void add(ItemStack ... itemStack) {
        this.inventory.addItem(itemStack);
    }

    protected void onClose() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void open() {
        if (this.update) {
            this.onUpdate(this.inventory);
        }
        this.player.openInventory(this.inventory);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PlayerKits.getInstance());
    }

    public void close() {
        this.player.closeInventory();
        this.onClose();
    }

    @Generated
    protected Player getPlayer() {
        return this.player;
    }

    @Generated
    protected Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    protected boolean isUpdate() {
        return this.update;
    }
}

