/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.database;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.libs.bson.Document;
import io.github.InsiderAnh.xPlayerKits.libs.bson.conversions.Bson;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.ConnectionString;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.MongoClient;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.MongoClients;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.IndexOptions;
import io.github.InsiderAnh.xPlayerKits.libs.mongodb.client.model.UpdateOptions;
import io.github.InsiderAnh.xPlayerKits.superclass.Database;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class MongoDatabase
extends Database {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private MongoClient mongoClient;
    private MongoCollection<Document> collection;

    @Override
    public void connect() {
        String connectionString = "mongodb://" + this.playerKits.getConfig().getString("databases.mongodb.user") + ":" + this.playerKits.getConfig().getString("databases.mongodb.password") + "@" + this.playerKits.getConfig().getString("databases.mongodb.host") + ":" + this.playerKits.getConfig().getInt("databases.mongodb.port");
        try {
            this.mongoClient = MongoClients.create(new ConnectionString(connectionString));
            this.collection = this.mongoClient.getDatabase(this.playerKits.getConfig().getString("databases.mongodb.database", "xPlayerKits")).getCollection("player_kits");
            this.collection.createIndex(new Document("uuid", 1), new IndexOptions().unique(true));
            this.collection.createIndex(new Document("name", 1));
            this.playerKits.getLogger().info("Connected to Mongo database correctly.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.playerKits.getLogger().warning("Error on connect to Mongo database.");
        }
    }

    @Override
    public void close() {
        this.mongoClient.close();
    }

    @Override
    public CompletableFuture<PlayerKitData> getPlayerDataByName(String name) {
        CompletableFuture<PlayerKitData> completableFuture = new CompletableFuture<PlayerKitData>();
        this.playerKits.getExecutor().execute(() -> {
            Document documentFound = (Document)this.collection.find(new Document("name", name)).first();
            if (documentFound != null) {
                PlayerKitData playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(documentFound.toJson(XPKUtils.getWriterSettings()), PlayerKitData.class);
                completableFuture.complete(playerKitData);
            } else {
                completableFuture.complete(null);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<PlayerKitData> getPlayerData(UUID uuid, String name) {
        CompletableFuture<PlayerKitData> completableFuture = new CompletableFuture<PlayerKitData>();
        this.playerKits.getExecutor().execute(() -> completableFuture.complete(this.getSyncPlayerData(uuid, name)));
        return completableFuture;
    }

    @Override
    public CompletableFuture<Boolean> loadPlayerData(UUID uuid, String name) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.playerKits.getExecutor().execute(() -> {
            PlayerKitData playerKitData;
            boolean firstJoin;
            Document documentFound = (Document)this.collection.find(new Document("uuid", uuid.toString())).first();
            if (documentFound != null) {
                firstJoin = false;
                playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(documentFound.toJson(XPKUtils.getWriterSettings()), PlayerKitData.class);
            } else {
                firstJoin = true;
                playerKitData = new PlayerKitData(uuid, name);
                Document document = Document.parse(XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
                this.collection.insertOne(document);
            }
            this.cachedPlayerKits.put(uuid, playerKitData);
            completableFuture.complete(firstJoin);
        });
        return completableFuture;
    }

    @Override
    public PlayerKitData getSyncPlayerData(UUID uuid, String name) {
        PlayerKitData playerKitData;
        Document documentFound = (Document)this.collection.find(new Document("uuid", uuid.toString())).first();
        if (documentFound != null) {
            playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(documentFound.toJson(XPKUtils.getWriterSettings()), PlayerKitData.class);
        } else {
            playerKitData = new PlayerKitData(uuid, name);
            Document document = Document.parse(XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
            this.collection.insertOne(document);
        }
        this.cachedPlayerKits.put(uuid, playerKitData);
        return playerKitData;
    }

    @Override
    public void updatePlayerData(UUID uuid) {
        PlayerKitData playerKitData = (PlayerKitData)this.cachedPlayerKits.get(uuid);
        if (playerKitData == null) {
            return;
        }
        Document document = Document.parse(XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
        this.collection.updateOne((Bson)new Document("uuid", uuid.toString()), (Bson)new Document("$set", document), new UpdateOptions().upsert(true));
    }
}

