/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.commands;

import com.google.common.base.Joiner;
import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.CountdownPlayer;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.managers.MigratorManager;
import io.github.InsiderAnh.xPlayerKits.menus.KitSlotEditorMenu;
import io.github.InsiderAnh.xPlayerKits.menus.KitsMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.MainKitEditorMenu;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class XKitsCommands
implements CommandExecutor {
    private final PlayerKits playerKits = PlayerKits.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            CountdownPlayer countdownPlayer = CountdownPlayer.getCountdownPlayer(player);
            if (countdownPlayer.isCountdown("kitCommandCountdown")) {
                player.sendMessage(this.playerKits.getLang().getString("messages.pleaseWait"));
                return true;
            }
            countdownPlayer.setCountdown("kitCommandCountdown", 1, TimeUnit.SECONDS);
            if (args.length < 1) {
                if (this.playerKits.getConfig().getBoolean("kitsCMD.enabled")) {
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(player.getUniqueId(), player.getName()).thenAccept(playerKitData -> Bukkit.getScheduler().runTask((Plugin)this.playerKits, () -> {
                        new KitsMenu(player, (PlayerKitData)playerKitData, 1).open();
                        countdownPlayer.resetCountdown("kitCommandCountdown");
                    }))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                } else {
                    this.sendHelp(sender);
                }
                return true;
            }
            block13 : switch (args[0].toLowerCase()) {
                case "editor": {
                    if (!player.hasPermission("xkits.admin")) {
                        player.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    new MainKitEditorMenu(player, 1).open();
                    countdownPlayer.resetCountdown("kitCommandCountdown");
                    break;
                }
                case "slots": {
                    if (!player.hasPermission("xkits.admin")) {
                        player.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    new KitSlotEditorMenu(player).open();
                    countdownPlayer.resetCountdown("kitCommandCountdown");
                    break;
                }
                case "give": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    Player online = Bukkit.getPlayer((String)args[2]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    if (online == null) {
                        sender.sendMessage("\u00a7cThis player is not online.");
                        return true;
                    }
                    kit.giveKit(online);
                    break;
                }
                case "delete": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().removeKit(args[1]);
                    if (kit != null) {
                        File fileKit = new File(this.playerKits.getDataFolder(), kit.getName() + ".yml");
                        if (fileKit.exists()) {
                            fileKit.delete();
                        }
                        sender.sendMessage(this.playerKits.getLang().getString("messages.deletedKit"));
                        break;
                    }
                    sender.sendMessage(this.playerKits.getLang().getString("messages.noExistsKit"));
                    break;
                }
                case "reset": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerDataByName(args[2]).thenAccept(playerKitData -> {
                        if (playerKitData == null) {
                            sender.sendMessage("\u00a7cThis user don\u00b4t have data.");
                            return;
                        }
                        playerKitData.getKitsData().remove(kit.getName());
                        this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                    })).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "resetall": {
                    if (args.length < 2) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerDataByName(args[1]).thenAccept(playerKitData -> {
                        if (playerKitData == null) {
                            sender.sendMessage("\u00a7cThis user don\u00b4t have data.");
                            return;
                        }
                        playerKitData.getKitsData().clear();
                        this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                    })).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "migrate": {
                    if (args.length < 2) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    switch (args[1].toLowerCase()) {
                        case "playerkits2_yml": {
                            new MigratorManager().migrateFromPlayerKits2MoreOptimized();
                            break block13;
                        }
                        case "playerkits2_mysql": {
                            new MigratorManager().migrateFromPlayerKits2MySQL();
                            break block13;
                        }
                    }
                    this.sendHelp(sender);
                    break;
                }
                case "migratekits": {
                    if (args.length < 2) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    switch (args[1].toLowerCase()) {
                        case "playerkits2": {
                            new MigratorManager().migrateKitsFromPlayerKits2(player);
                            break block13;
                        }
                    }
                    this.sendHelp(sender);
                    break;
                }
                case "claim": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    Player online = Bukkit.getPlayer((String)args[2]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    if (online == null) {
                        sender.sendMessage("\u00a7cThis player is not online.");
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(online.getUniqueId(), online.getName()).thenAccept(playerKitData -> Bukkit.getScheduler().runTask((Plugin)this.playerKits, () -> XPKUtils.claimKit(online, kit, playerKitData)))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "kits": {
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(player.getUniqueId(), player.getName()).thenAccept(playerKitData -> Bukkit.getScheduler().runTask((Plugin)this.playerKits, () -> {
                        new KitsMenu(player, (PlayerKitData)playerKitData, 1).open();
                        countdownPlayer.resetCountdown("kitCommandCountdown");
                    }))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "reload": {
                    this.playerKits.reload();
                    sender.sendMessage("\u00a7aPlugin reloaded correctly.");
                    break;
                }
                default: {
                    this.sendHelp(sender);
                }
            }
        } else {
            if (args.length < 1) {
                this.sendHelp(sender);
                return true;
            }
            block49 : switch (args[0].toLowerCase()) {
                case "give": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    Player online = Bukkit.getPlayer((String)args[2]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    if (online == null) {
                        sender.sendMessage("\u00a7cThis player is not online.");
                        return true;
                    }
                    kit.giveKit(online);
                    break;
                }
                case "claim": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    Player online = Bukkit.getPlayer((String)args[2]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    if (online == null) {
                        sender.sendMessage("\u00a7cThis player is not online.");
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(online.getUniqueId(), online.getName()).thenAccept(playerKitData -> Bukkit.getScheduler().runTask((Plugin)this.playerKits, () -> XPKUtils.claimKit(online, kit, playerKitData)))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "delete": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().removeKit(Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(args, 2, args.length)));
                    if (kit != null) {
                        File fileKit = new File(this.playerKits.getDataFolder(), kit.getName() + ".yml");
                        if (fileKit.exists()) {
                            fileKit.delete();
                        }
                        sender.sendMessage(this.playerKits.getLang().getString("messages.deletedKit"));
                        break;
                    }
                    sender.sendMessage(this.playerKits.getLang().getString("messages.noExistsKit"));
                    break;
                }
                case "reset": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    Kit kit = this.playerKits.getKitManager().getKit(args[1]);
                    if (kit == null) {
                        sender.sendMessage("\u00a7cThis kit don\u00b4t exists.");
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerDataByName(args[2]).thenAccept(playerKitData -> {
                        if (playerKitData == null) {
                            sender.sendMessage("\u00a7cThis user don\u00b4t have data.");
                            return;
                        }
                        playerKitData.getKitsData().remove(kit.getName());
                        this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                    })).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "resetall": {
                    if (args.length < 3) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerDataByName(args[1]).thenAccept(playerKitData -> {
                        if (playerKitData == null) {
                            sender.sendMessage("\u00a7cThis user don\u00b4t have data.");
                            return;
                        }
                        playerKitData.getKitsData().clear();
                        this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                    })).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    break;
                }
                case "migrate": {
                    if (args.length < 2) {
                        this.sendHelp(sender);
                        return true;
                    }
                    if (!sender.hasPermission("xkits.admin")) {
                        sender.sendMessage(this.playerKits.getLang().getString("messages.noPermission"));
                        return true;
                    }
                    switch (args[1].toLowerCase()) {
                        case "playerkits2_yml": {
                            new MigratorManager().migrateFromPlayerKits2MoreOptimized();
                            break block49;
                        }
                        case "playerkits2_mysql": {
                            new MigratorManager().migrateFromPlayerKits2MySQL();
                            break block49;
                        }
                    }
                    this.sendHelp(sender);
                    break;
                }
                case "reload": {
                    this.playerKits.reload();
                    sender.sendMessage("\u00a7aPlugin reloaded correctly.");
                    break;
                }
                default: {
                    this.sendHelp(sender);
                }
            }
        }
        return false;
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a77\u00a7m--------------------------------------");
        sender.sendMessage("\u00a7e/xkits editor \u00a77- \u00a7fOpens the kit editor.");
        sender.sendMessage("\u00a7e/xkits slots \u00a77- \u00a7fOpens the kit slot editor.");
        sender.sendMessage("\u00a7e/xkits kits \u00a77- \u00a7fOpens the kit menu.");
        sender.sendMessage("\u00a7e/xkits give <kitName> <player> \u00a77- \u00a7fDirectly give kits to players without verifications..");
        sender.sendMessage("\u00a7e/xkits claim <kitName> <player> \u00a77- \u00a7fGive kits to players with verifications.");
        sender.sendMessage("\u00a7e/xkits delete <kitName> \u00a77- \u00a7fDelete a kit.");
        sender.sendMessage("\u00a7e/xkits reset <kitName> <player> \u00a77- \u00a7fReset a certain kit data.");
        sender.sendMessage("\u00a7e/xkits resetall <player> \u00a77- \u00a7fReset all kit data.");
        sender.sendMessage("\u00a7e/xkits migrate playerkits2_yml/playerkits2_mysql \u00a77- \u00a7fMigrate data from playerkits2 plugin.");
        sender.sendMessage("\u00a7e/xkits migratekits playerkits2 \u00a77- \u00a7fMigrate kit from playerkits2 plugin.");
        sender.sendMessage("\u00a77\u00a7m--------------------------------------");
    }
}

