/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.xPlayerKits.commands.XKitsCommands;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.database.MongoDatabase;
import io.github.InsiderAnh.xPlayerKits.database.MySQLDatabase;
import io.github.InsiderAnh.xPlayerKits.database.SQLiteDatabase;
import io.github.InsiderAnh.xPlayerKits.listeners.PlayerListener;
import io.github.InsiderAnh.xPlayerKits.managers.ConfigManager;
import io.github.InsiderAnh.xPlayerKits.managers.KitManager;
import io.github.InsiderAnh.xPlayerKits.placeholders.PlayerKitsPlaceholders;
import io.github.InsiderAnh.xPlayerKits.superclass.Database;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerKits
extends JavaPlugin {
    private static PlayerKits instance;
    private final ListeningExecutorService executor;
    private final KitManager kitManager;
    private final ConfigManager configManager;
    private InsiderConfig lang;
    private InsiderConfig inventories;
    private Database database;

    public PlayerKits() {
        instance = this;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.kitManager = new KitManager();
        this.configManager = new ConfigManager();
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.lang = new InsiderConfig(this, "lang", true, false);
        this.inventories = new InsiderConfig(this, "inventories", true, false);
        String databaseType = this.getConfig().getString("databases.databaseType", "h2");
        this.database = databaseType.equalsIgnoreCase("mysql") ? new MySQLDatabase() : (databaseType.equalsIgnoreCase("mongodb") ? new MongoDatabase() : new SQLiteDatabase());
        this.database.connect();
        this.configManager.load();
        this.kitManager.load();
        this.getCommand("xkits").setExecutor((CommandExecutor)new XKitsCommands());
        if (this.getConfig().getBoolean("kitsCMD.enabled")) {
            this.getCommand("kits").setExecutor((CommandExecutor)new XKitsCommands());
        }
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlayerKitsPlaceholders().register();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
    }

    public void onDisable() {
        this.database.close();
    }

    public void reload() {
        boolean lasEnabled = this.getConfig().getBoolean("kitsCMD.enabled");
        this.reloadConfig();
        this.lang.reload();
        this.inventories.reload();
        this.configManager.load();
        this.kitManager.load();
        if (!lasEnabled && this.getConfig().getBoolean("kitsCMD.enabled")) {
            this.getCommand("kits").setExecutor((CommandExecutor)new XKitsCommands());
        }
    }

    @Generated
    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public KitManager getKitManager() {
        return this.kitManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public InsiderConfig getLang() {
        return this.lang;
    }

    @Generated
    public InsiderConfig getInventories() {
        return this.inventories;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public static PlayerKits getInstance() {
        return instance;
    }
}

