/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.Material;

public class WorldUtils {
    private static final BiMap<String, Integer> worldIds = HashBiMap.create();

    public static String getFormatedLocation(LocationCache cache) {
        return "x" + cache.getX() + "/y" + cache.getY() + "/z" + cache.getZ() + "/" + WorldUtils.getWorld(cache.getWorldId());
    }

    public static String getWorld(int id) {
        return (String)worldIds.inverse().get((Object)id);
    }

    public static void cacheWorld(String world, int id) {
        worldIds.put((Object)world, (Object)id);
    }

    public static int searchWorldId(String world) {
        for (String worldId : worldIds.keySet()) {
            if (!worldId.equalsIgnoreCase(world)) continue;
            return (Integer)worldIds.get((Object)worldId);
        }
        return -1;
    }

    public static int getShortId(String world) {
        if (worldIds.containsKey((Object)world)) {
            return (Integer)worldIds.get((Object)world);
        }
        int shortId = WorldUtils.generateShortId(world);
        worldIds.put((Object)world, (Object)shortId);
        StellarProtect.getInstance().getProtectDatabase().saveWorld(world, shortId);
        return shortId;
    }

    private static int generateShortId(String word) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(word.getBytes(StandardCharsets.UTF_8));
            int value = 0;
            for (int i = 0; i < 4; ++i) {
                value = value << 8 | hash[i] & 0xFF;
            }
            return Math.abs(value) % 10000;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 no disponible");
        }
    }

    public static boolean isValidChestBlock(Material material) {
        return material.equals((Object)Material.CHEST) || material.equals((Object)Material.TRAPPED_CHEST) || material.equals((Object)Material.ENDER_CHEST) || material.equals((Object)Material.DROPPER) || material.name().endsWith("SHULKER_BOX") || material.name().contains("BARREL") || material.name().endsWith("COPPER_CHEST");
    }
}

