/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import io.github.insideranh.stellarprotect.items.MinecraftItem;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringCleanerUtils {
    private static final DecimalFormat format = new DecimalFormat("###,###,###.##");
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();
    private static final HashMap<String, String> MATERIAL_TRANSLATIONS = new HashMap();
    private static final Pattern pattern = Pattern.compile("\"m\":\"([^\"]+)\"");
    private static boolean HAS_TRANSLATION = false;

    public static void setHasTranslation(boolean hasTranslation) {
        MATERIAL_TRANSLATIONS.clear();
        HAS_TRANSLATION = hasTranslation;
    }

    public static void addMaterialTranslation(String material, String translation) {
        MATERIAL_TRANSLATIONS.put(material.toLowerCase(), translation);
    }

    public static double limitTo2Decimals(double value) {
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static String formatNumber(double amount) {
        return format.format(amount);
    }

    public static String formatEconomy(double value) {
        if (value == Double.MIN_VALUE) {
            return StringCleanerUtils.formatEconomy(1.0);
        }
        if (value < 0.0) {
            return "-" + StringCleanerUtils.formatEconomy(-value);
        }
        if (value < 1000.0) {
            return StringCleanerUtils.formatNumber(value);
        }
        Map.Entry<Long, String> e = SUFFIXES.floorEntry((long)value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = (long)(value / (double)(divideBy / 10L));
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    private static String cleanMinecraftName(String name) {
        String translation;
        if (name == null || name.length() < 2) {
            return name;
        }
        boolean isNexo = name.startsWith("nexo:");
        if (isNexo) {
            name = name.substring(5);
        }
        String cleanedData = StringCleanerUtils.cleanMinecraft(name);
        if (HAS_TRANSLATION && (translation = MATERIAL_TRANSLATIONS.get(cleanedData.toLowerCase())) != null) {
            return translation;
        }
        int bracketIndex = cleanedData.indexOf(91);
        if (bracketIndex != -1) {
            cleanedData = cleanedData.substring(0, bracketIndex);
        }
        StringBuilder builder = new StringBuilder();
        for (String word : cleanedData.split("_")) {
            if (word.isEmpty()) continue;
            builder.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase()).append(" ");
        }
        if (isNexo) {
            return "nexo:" + builder.toString().trim();
        }
        return builder.toString().trim();
    }

    private static String cleanMinecraft(String name) {
        if (name.startsWith("minecraft:")) {
            return name.replaceFirst("minecraft:", "");
        }
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return name;
    }

    public static MinecraftItem parseMinecraftData(String data) {
        String itemName;
        if (data == null || data.isEmpty()) {
            return new MinecraftItem("", new HashMap<String, String>());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        int bracketIndex = data.indexOf(91);
        if (bracketIndex != -1) {
            itemName = data.substring(0, bracketIndex);
            String propertiesString = data.substring(bracketIndex + 1, data.lastIndexOf(93));
            if (!propertiesString.isEmpty()) {
                String[] pairs;
                for (String pair : pairs = propertiesString.split(",")) {
                    String[] keyValue = pair.trim().split("=");
                    if (keyValue.length != 2) continue;
                    String key = keyValue[0].trim();
                    String value = keyValue[1].trim();
                    key = key.substring(0, 1).toUpperCase() + key.substring(1);
                    value = value.substring(0, 1).toUpperCase() + value.substring(1);
                    properties.put(key, value);
                }
            }
        } else {
            itemName = data;
        }
        String cleanName = StringCleanerUtils.cleanMinecraftName(itemName);
        return new MinecraftItem(cleanName, properties);
    }

    static {
        SUFFIXES.put(1000L, "k");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "B");
        SUFFIXES.put(1000000000000L, "T");
        SUFFIXES.put(1000000000000000L, "Q");
        SUFFIXES.put(1000000000000000000L, "Qi");
    }
}

