/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.nms.v1_8_R3;

import io.github.insideranh.stellarprotect.entities.DataEntity;
import io.github.insideranh.stellarprotect.entities.DataEntityType;
import java.util.HashMap;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Rotation;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class DataEntity_v1_8_R3
implements DataEntity {
    private final HashMap<String, Object> data = new HashMap();
    private ItemStack[] armor;
    private ItemStack mainHand;
    private ItemStack offHand;

    public DataEntity_v1_8_R3(Entity entity) {
        this.readEntityData(entity);
    }

    public DataEntity_v1_8_R3(HashMap<String, Object> data) {
        this.data.putAll(data);
    }

    public DataEntity_v1_8_R3() {
    }

    private void readEntityData(Entity entity) {
        this.setData(DataEntityType.ENTITY_TYPE, entity.getType().name());
        if (entity.getCustomName() != null) {
            this.setData(DataEntityType.CUSTOM_NAME, entity.getCustomName());
        }
        this.setData((Enum<?>)DataEntityType.CUSTOM_NAME_VISIBLE, entity.isCustomNameVisible());
        if (entity instanceof LivingEntity) {
            this.readLivingEntityData((LivingEntity)entity);
        }
        if (entity instanceof ArmorStand) {
            this.readArmorStandData((ArmorStand)entity);
        }
        if (entity instanceof ItemFrame) {
            this.readItemFrameData((ItemFrame)entity);
        }
    }

    private void readLivingEntityData(LivingEntity entity) {
        this.setData((Enum<?>)DataEntityType.HEALTH, entity.getHealth());
        this.readSpecificMobData(entity);
    }

    private void readSpecificMobData(LivingEntity entity) {
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.setData(DataEntityType.VILLAGER_PROFESSION, villager.getProfession().name());
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.setData((Enum<?>)DataEntityType.ANGRY, wolf.isAngry());
            if (wolf.isTamed()) {
                Color collarColor = wolf.getCollarColor().getColor();
                this.setData(DataEntityType.COLLAR_COLOR, collarColor.getRed() + "," + collarColor.getGreen() + "," + collarColor.getBlue());
            }
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.setData(DataEntityType.HORSE_COLOR, horse.getColor().name());
            this.setData(DataEntityType.HORSE_STYLE, horse.getStyle().name());
            this.setData((Enum<?>)DataEntityType.JUMP_STRENGTH, horse.getJumpStrength());
            if (horse.getInventory().getSaddle() != null) {
                this.setData((Enum<?>)DataEntityType.HAS_SADDLE, true);
            }
            if (horse.getInventory().getArmor() != null) {
                this.setData(DataEntityType.HORSE_ARMOR, horse.getInventory().getArmor());
            }
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            this.setData(DataEntityType.RABBIT_TYPE, rabbit.getRabbitType().name());
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            this.setData(DataEntityType.SHEEP_COLOR, sheep.getColor().name());
            this.setData((Enum<?>)DataEntityType.SHEEP_SHEARED, sheep.isSheared());
        } else if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            this.setData((Enum<?>)DataEntityType.PIG_SADDLED, pig.hasSaddle());
        } else if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            this.setData((Enum<?>)DataEntityType.CREEPER_POWERED, creeper.isPowered());
        } else if (entity instanceof Enderman) {
            Enderman creeper = (Enderman)entity;
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            this.setData((Enum<?>)DataEntityType.SLIME_SIZE, slime.getSize());
        } else if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            this.setData((Enum<?>)DataEntityType.ZOMBIE_BABY, zombie.isBaby());
        } else if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            this.setData((Enum<?>)DataEntityType.IRON_GOLEM_PLAYER_CREATED, golem.isPlayerCreated());
        }
    }

    private void readArmorStandData(ArmorStand stand) {
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_ARMS, stand.hasArms());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_BASE_PLATE, stand.hasBasePlate());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_MARKER, stand.isMarker());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_SMALL, stand.isSmall());
        this.setData((Enum<?>)DataEntityType.ARMOR_STAND_VISIBLE, stand.isVisible());
        this.setData(DataEntityType.ARMOR_STAND_HEAD_POSE, this.eulerToString(stand.getHeadPose()));
        this.setData(DataEntityType.ARMOR_STAND_BODY_POSE, this.eulerToString(stand.getBodyPose()));
        this.setData(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE, this.eulerToString(stand.getLeftArmPose()));
        this.setData(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE, this.eulerToString(stand.getRightArmPose()));
        this.setData(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE, this.eulerToString(stand.getLeftLegPose()));
        this.setData(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE, this.eulerToString(stand.getRightLegPose()));
        if (stand.getEquipment() != null) {
            EntityEquipment eq = stand.getEquipment();
            this.armor = eq.getArmorContents();
            this.mainHand = eq.getItemInHand();
        }
    }

    private void readItemFrameData(ItemFrame frame) {
        this.setData(DataEntityType.ITEM_FRAME_ITEM, frame.getItem());
        this.setData(DataEntityType.ITEM_FRAME_ROTATION, frame.getRotation().name());
    }

    @Override
    public void applyToEntity(Entity entity) {
        if (this.hasData(DataEntityType.CUSTOM_NAME)) {
            entity.setCustomName((String)this.getData(DataEntityType.CUSTOM_NAME));
        }
        entity.setCustomNameVisible(this.getBoolean(DataEntityType.CUSTOM_NAME_VISIBLE));
        if (entity instanceof LivingEntity) {
            this.applyLivingEntityData((LivingEntity)entity);
        }
        if (entity instanceof ArmorStand) {
            this.applyArmorStandData((ArmorStand)entity);
        }
        if (entity instanceof ItemFrame) {
            this.applyItemFrameData((ItemFrame)entity);
        }
    }

    private void applyLivingEntityData(LivingEntity entity) {
        if (this.hasData(DataEntityType.HEALTH)) {
            entity.setHealth(Math.max(this.getDouble(DataEntityType.HEALTH), 1.0));
        }
        this.applySpecificMobData(entity);
    }

    private void applySpecificMobData(LivingEntity entity) {
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (this.hasData(DataEntityType.VILLAGER_PROFESSION)) {
                String typeKey = this.getString(DataEntityType.VILLAGER_PROFESSION);
                for (Villager.Profession profession : Villager.Profession.values()) {
                    if (!profession.name().equals(typeKey)) continue;
                    villager.setProfession(profession);
                    break;
                }
            }
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            if (this.hasData(DataEntityType.ANGRY)) {
                wolf.setAngry(this.getBoolean(DataEntityType.ANGRY));
            }
            if (this.hasData(DataEntityType.COLLAR_COLOR) && wolf.isTamed()) {
                String[] rgb = this.getString(DataEntityType.COLLAR_COLOR).split(",");
                Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                for (DyeColor dyeColor : DyeColor.values()) {
                    if (!dyeColor.getColor().equals((Object)color)) continue;
                    wolf.setCollarColor(dyeColor);
                    break;
                }
            }
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            if (this.hasData(DataEntityType.HORSE_COLOR)) {
                horse.setColor(Horse.Color.valueOf((String)this.getString(DataEntityType.HORSE_COLOR)));
            }
            if (this.hasData(DataEntityType.HORSE_STYLE)) {
                horse.setStyle(Horse.Style.valueOf((String)this.getString(DataEntityType.HORSE_STYLE)));
            }
            if (this.hasData(DataEntityType.JUMP_STRENGTH)) {
                horse.setJumpStrength(this.getDouble(DataEntityType.JUMP_STRENGTH));
            }
            if (this.hasData(DataEntityType.HORSE_ARMOR)) {
                horse.getInventory().setArmor((ItemStack)this.getData(DataEntityType.HORSE_ARMOR));
            }
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            if (this.hasData(DataEntityType.RABBIT_TYPE)) {
                rabbit.setRabbitType(Rabbit.Type.valueOf((String)this.getString(DataEntityType.RABBIT_TYPE)));
            }
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (this.hasData(DataEntityType.SHEEP_COLOR)) {
                sheep.setColor(DyeColor.valueOf((String)this.getString(DataEntityType.SHEEP_COLOR)));
            }
            if (this.hasData(DataEntityType.SHEEP_SHEARED)) {
                sheep.setSheared(this.getBoolean(DataEntityType.SHEEP_SHEARED));
            }
        } else if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (this.hasData(DataEntityType.PIG_SADDLED)) {
                pig.setSaddle(this.getBoolean(DataEntityType.PIG_SADDLED));
            }
        } else if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            if (this.hasData(DataEntityType.CREEPER_POWERED)) {
                creeper.setPowered(this.getBoolean(DataEntityType.CREEPER_POWERED));
            }
        } else if (entity instanceof Enderman) {
            Enderman creeper = (Enderman)entity;
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            if (this.hasData(DataEntityType.SLIME_SIZE)) {
                slime.setSize(this.getInt(DataEntityType.SLIME_SIZE));
            }
        } else if (entity instanceof Zombie) {
            Zombie zombie = (Zombie)entity;
            if (this.hasData(DataEntityType.ZOMBIE_BABY)) {
                zombie.setBaby(this.getBoolean(DataEntityType.ZOMBIE_BABY));
            }
        } else if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (this.hasData(DataEntityType.IRON_GOLEM_PLAYER_CREATED)) {
                golem.setPlayerCreated(this.getBoolean(DataEntityType.IRON_GOLEM_PLAYER_CREATED));
            }
        }
    }

    private void applyArmorStandData(ArmorStand stand) {
        if (this.hasData(DataEntityType.ARMOR_STAND_ARMS)) {
            stand.setArms(this.getBoolean(DataEntityType.ARMOR_STAND_ARMS));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_BASE_PLATE)) {
            stand.setBasePlate(this.getBoolean(DataEntityType.ARMOR_STAND_BASE_PLATE));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_MARKER)) {
            stand.setMarker(this.getBoolean(DataEntityType.ARMOR_STAND_MARKER));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_SMALL)) {
            stand.setSmall(this.getBoolean(DataEntityType.ARMOR_STAND_SMALL));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_VISIBLE)) {
            stand.setVisible(this.getBoolean(DataEntityType.ARMOR_STAND_VISIBLE));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_HEAD_POSE)) {
            stand.setHeadPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_HEAD_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_BODY_POSE)) {
            stand.setBodyPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_BODY_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE)) {
            stand.setLeftArmPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_LEFT_ARM_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE)) {
            stand.setRightArmPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_RIGHT_ARM_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE)) {
            stand.setLeftLegPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_LEFT_LEG_POSE)));
        }
        if (this.hasData(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE)) {
            stand.setRightLegPose(this.stringToEuler(this.getString(DataEntityType.ARMOR_STAND_RIGHT_LEG_POSE)));
        }
        if (stand.getEquipment() != null) {
            EntityEquipment eq = stand.getEquipment();
            if (this.armor != null) {
                eq.setArmorContents(this.armor);
            }
            if (this.mainHand != null) {
                eq.setItemInHand(this.mainHand);
            }
        }
    }

    private void applyItemFrameData(ItemFrame frame) {
        if (this.hasData(DataEntityType.ITEM_FRAME_ITEM)) {
            frame.setItem((ItemStack)this.getData(DataEntityType.ITEM_FRAME_ITEM));
        }
        if (this.hasData(DataEntityType.ITEM_FRAME_ROTATION)) {
            frame.setRotation(Rotation.valueOf((String)this.getString(DataEntityType.ITEM_FRAME_ROTATION)));
        }
    }

    private void setData(Enum<?> key, boolean value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, int value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, double value) {
        this.data.put(key.name(), value);
    }

    private void setData(Enum<?> key, String value) {
        if (value != null && !value.isEmpty()) {
            this.data.put(key.name(), value);
        }
    }

    private void setData(Enum<?> key, Object value) {
        if (value != null) {
            this.data.put(key.name(), value);
        }
    }

    private boolean hasData(Enum<?> key) {
        return this.data.containsKey(key.name());
    }

    private Object getData(Enum<?> key) {
        return this.data.get(key.name());
    }

    private boolean getBoolean(Enum<?> key) {
        return this.hasData(key) && (Boolean)this.getData(key) != false;
    }

    private int getInt(Enum<?> key) {
        return this.hasData(key) ? ((Number)this.getData(key)).intValue() : 0;
    }

    private double getDouble(Enum<?> key) {
        return this.hasData(key) ? ((Number)this.getData(key)).doubleValue() : 0.0;
    }

    private String getString(Enum<?> key) {
        return this.hasData(key) ? (String)this.getData(key) : "";
    }

    private String eulerToString(EulerAngle angle) {
        return angle.getX() + "," + angle.getY() + "," + angle.getZ();
    }

    private EulerAngle stringToEuler(String str) {
        String[] parts = str.split(",");
        return new EulerAngle(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]));
    }

    @Override
    public HashMap<String, Object> getData() {
        return this.data;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public ItemStack getMainHand() {
        return this.mainHand;
    }

    public ItemStack getOffHand() {
        return this.offHand;
    }
}

