/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import com.google.gson.Gson;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockStateLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerKillLogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.restore.BlockRestore;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.SerializerUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class UndoManager {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void preview(Player sender, Map<LocationCache, Set<LogEntry>> groupedLogs, boolean verbose, boolean silent) {
        Gson gson = SerializerUtils.getGson();
        int processedCount = 0;
        int MAX_PER_TICK = 50;
        block2: for (Map.Entry<LocationCache, Set<LogEntry>> entry : groupedLogs.entrySet()) {
            for (LogEntry logEntry : entry.getValue()) {
                String materialName;
                if (logEntry instanceof PlayerBlockLogEntry) {
                    PlayerBlockLogEntry blockLogEntry = (PlayerBlockLogEntry)logEntry;
                    Location location = blockLogEntry.asBukkitLocation();
                    if (verbose) {
                        String actionName = blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() ? "PLACE" : "BREAK";
                        materialName = blockLogEntry.getDataString().split(":")[0];
                        sender.sendMessage("\u00a77[VERBOSE UNDO] \u00a7e" + actionName + " \u00a77at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77material: \u00a7f" + materialName + " \u00a77by \u00a7f" + PlayerUtils.getNameOfEntity(blockLogEntry.getPlayerId()) + " \u00a77(ID: " + blockLogEntry.getPlayerId() + ") \u00a77at \u00a7f" + new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(new Date(blockLogEntry.getCreatedAt())));
                    }
                    BlockRestore blockRestore = this.plugin.getBlockRestore(blockLogEntry.getDataString());
                    if (blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() || blockLogEntry.getActionType() == ActionType.BUCKET_EMPTY.getId()) {
                        this.plugin.getStellarTaskHook(() -> blockRestore.preview(sender, gson, location)).runTask(location);
                    } else if (blockLogEntry.getActionType() == ActionType.BLOCK_BREAK.getId() || blockLogEntry.getActionType() == ActionType.BUCKET_FILL.getId()) {
                        this.plugin.getStellarTaskHook(() -> blockRestore.previewRemove(sender, location)).runTask(location);
                    }
                } else if (logEntry instanceof PlayerBlockStateLogEntry) {
                    PlayerBlockStateLogEntry blockStateLogEntry = (PlayerBlockStateLogEntry)logEntry;
                    BlockRestore blockRestore = this.plugin.getBlockRestore(blockStateLogEntry.getDataString());
                    Location location = blockStateLogEntry.asBukkitLocation();
                    if (verbose) {
                        materialName = blockStateLogEntry.getDataString().split(":")[0];
                        sender.sendMessage("\u00a77[VERBOSE UNDO] \u00a7eSTATE_CHANGE \u00a77at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77material: \u00a7f" + materialName + " \u00a77by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77(ID: " + blockStateLogEntry.getPlayerId() + ") \u00a77at \u00a7f" + new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(new Date(blockStateLogEntry.getCreatedAt())));
                    }
                    if (!silent) {
                        this.plugin.getStellarTaskHook(() -> blockRestore.preview(sender, gson, location)).runTask(location);
                    }
                }
                if (++processedCount % 50 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
    }

    public void undo(CommandSender sender, Map<LocationCache, Set<LogEntry>> groupedLogs, boolean verbose) {
        int processedCount = 0;
        int MAX_PER_TICK = 50;
        block2: for (Map.Entry<LocationCache, Set<LogEntry>> entry : groupedLogs.entrySet()) {
            for (LogEntry logEntry : entry.getValue()) {
                this.undoRestore(logEntry, sender, verbose);
                if (++processedCount % 50 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
    }

    public void undoRestore(LogEntry logEntry, CommandSender sender, boolean verbose) {
        Gson gson = SerializerUtils.getGson();
        if (logEntry instanceof PlayerBlockLogEntry) {
            PlayerBlockLogEntry blockLogEntry = (PlayerBlockLogEntry)logEntry;
            Location location = blockLogEntry.asBukkitLocation();
            if (verbose) {
                String actionName = blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() ? "RE-PLACING" : "RE-REMOVING";
                sender.sendMessage("\u00a77[VERBOSE UNDO] \u00a7a" + actionName + " \u00a77block at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77(originally by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77ID: " + blockLogEntry.getPlayerId() + "\u00a77) \u00a77data: \u00a7f" + blockLogEntry.getDataString());
            }
            BlockRestore blockRestore = this.plugin.getBlockRestore(blockLogEntry.getDataString(), blockLogEntry.getExtraType(), blockLogEntry.getExtraData());
            if (blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() || blockLogEntry.getActionType() == ActionType.BUCKET_EMPTY.getId()) {
                this.plugin.getStellarTaskHook(() -> blockRestore.reset(gson, location)).runTask(location);
            } else if (blockLogEntry.getActionType() == ActionType.BLOCK_BREAK.getId() || blockLogEntry.getActionType() == ActionType.BUCKET_FILL.getId()) {
                this.plugin.getStellarTaskHook(() -> blockRestore.remove(location)).runTask(location);
            }
        } else if (logEntry instanceof PlayerBlockStateLogEntry) {
            PlayerBlockStateLogEntry blockStateLogEntry = (PlayerBlockStateLogEntry)logEntry;
            BlockRestore blockRestore = this.plugin.getBlockRestore(blockStateLogEntry.getDataString());
            Location location = blockStateLogEntry.asBukkitLocation();
            if (verbose) {
                sender.sendMessage("\u00a77[VERBOSE UNDO] \u00a7aRESTORING \u00a77state at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77(originally by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77ID: " + blockStateLogEntry.getPlayerId() + "\u00a77) \u00a77data: \u00a7f" + blockStateLogEntry.getDataString());
            }
            this.plugin.getStellarTaskHook(() -> blockRestore.reset(gson, location)).runTask(location);
        } else if (logEntry instanceof PlayerKillLogEntry) {
            PlayerKillLogEntry playerKillLogEntry = (PlayerKillLogEntry)logEntry;
            if (playerKillLogEntry.getEntityType().equals("PLAYER")) {
                return;
            }
            Location location = playerKillLogEntry.asBukkitLocation();
            if (verbose) {
                sender.sendMessage("\u00a77[VERBOSE UNDO] \u00a7aREMOVING \u00a77restored entity at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77type: \u00a7f" + playerKillLogEntry.getEntityType());
            }
            location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0).stream().filter(entity -> entity.getType().name().equals(playerKillLogEntry.getEntityType())).forEach(Entity::remove);
        }
    }
}

