/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.BlockSourceCache;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.enums.ActionCategory;
import io.github.insideranh.stellarprotect.hooks.tasks.TaskCanceller;
import java.util.concurrent.ThreadLocalRandom;

public class CacheManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private TaskCanceller saveTask;
    private TaskCanceller deleteOldTask;
    private TaskCanceller saveItemTask;
    private TaskCanceller blockSaveTask;
    private TaskCanceller queueProcessTask;

    public void load() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        if (this.deleteOldTask != null) {
            this.deleteOldTask.cancel();
        }
        if (this.saveItemTask != null) {
            this.saveItemTask.cancel();
        }
        if (this.blockSaveTask != null) {
            this.blockSaveTask.cancel();
        }
        if (this.queueProcessTask != null) {
            this.queueProcessTask.cancel();
        }
        this.saveTask = this.plugin.getStellarTaskHook(() -> {
            this.plugin.getProtectDatabase().save(LoggerCache.getFlushLogsToDatabase());
            LoggerCache.clearRamCache();
        }).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getSavePeriod() * 20L, (long)this.plugin.getConfigManager().getSavePeriod() * 20L);
        this.deleteOldTask = this.plugin.getStellarTaskHook(() -> {
            this.plugin.getProtectDatabase().clearOldLogs();
            this.plugin.getChestTransactionTracker().cleanupOldStates();
            BlockSourceCache.cleanup();
        }).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getDeleteOldPeriod() * 20L, (long)this.plugin.getConfigManager().getDeleteOldPeriod() * 20L);
        this.saveItemTask = this.plugin.getStellarTaskHook(() -> this.plugin.getItemsManager().saveItems()).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getSaveItemPeriod() + (long)ThreadLocalRandom.current().nextInt(0, 5) * 20L, (long)this.plugin.getConfigManager().getSaveItemPeriod() * 20L);
        this.blockSaveTask = this.plugin.getStellarTaskHook(() -> this.plugin.getBlocksManager().saveBlocks()).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getSaveBlockPeriod() + (long)ThreadLocalRandom.current().nextInt(0, 5) * 20L, (long)this.plugin.getConfigManager().getSaveBlockPeriod() * 20L);
        this.queueProcessTask = this.plugin.getStellarTaskHook(() -> this.plugin.getProtectDatabase().processQueueLogs()).runTaskTimerAsynchronously((long)this.plugin.getConfigManager().getQueueProcessPeriod() * 20L, (long)this.plugin.getConfigManager().getQueueProcessPeriod() * 20L);
    }

    public void forceSave(ActionCategory actionCategory) {
        this.plugin.getProtectDatabase().save(LoggerCache.getFlushLogsToDatabase(actionCategory));
    }
}

