/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners.handlers.interacts;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.api.ProtectNMS;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.database.entries.world.CropGrowLogEntry;
import io.github.insideranh.stellarprotect.listeners.handlers.GenericHandler;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerGrowCropHandler
extends GenericHandler {
    private final ProtectNMS protectNMS = StellarProtect.getInstance().getProtectNMS();

    @Override
    public GenericHandler canHandle(@NonNull Block block, @NonNull Material blockType, @NonNull String itemType) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (blockType == null) {
            throw new NullPointerException("blockType is marked non-null but is null");
        }
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (itemType.equals("BONE") && this.protectNMS.canGrow(block)) {
            return this;
        }
        return null;
    }

    @Override
    public void handle(Player player, long playerId, @NonNull Block block, ItemStack itemStack) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        LoggerCache.addLog(new CropGrowLogEntry(playerId, block));
    }
}

