/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.blocks.adjacents.AdjacentTracker;
import io.github.insideranh.stellarprotect.blocks.adjacents.AdjacentType;
import io.github.insideranh.stellarprotect.cache.BlockSourceCache;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.callback.CallbackSource;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockStateLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerItemLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerTameEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.items.ItemReference;
import io.github.insideranh.stellarprotect.trackers.BlockTracker;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BlockListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public static void processBlockBreak(Block block, @Nullable Player player, long defaultId) {
        StellarProtect plugin = StellarProtect.getInstance();
        Material material = block.getType();
        if (block.getType().equals((Object)Material.AIR) || ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), material.name())) {
            return;
        }
        long playerId = BlockListener.getPlayerId(player, defaultId);
        if (plugin.getNexoHook() != null && plugin.getNexoHook().isNexoBlock(block)) {
            return;
        }
        if (plugin.getItemsAdderHook() != null && plugin.getItemsAdderHook().isItemsAdderBlock(block)) {
            return;
        }
        HashMap<Location, Block> blockMap = new HashMap<Location, Block>();
        blockMap.put(block.getLocation(), block);
        BlockListener.scanAdjacentBlocks(blockMap);
        for (Map.Entry entry : blockMap.entrySet()) {
            Block affectedBlock = (Block)entry.getValue();
            if (ActionType.BLOCK_BREAK.shouldSkipLog(affectedBlock.getWorld().getName(), affectedBlock.getType().name())) continue;
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, affectedBlock, ActionType.BLOCK_BREAK));
        }
    }

    private static void scanAdjacentBlocks(Map<Location, Block> blockMap) {
        LinkedList<Block> blocksToScan = new LinkedList<Block>(blockMap.values());
        while (!blocksToScan.isEmpty()) {
            Block block = (Block)blocksToScan.poll();
            Material material = block.getType();
            Block above = block.getRelative(0, 1, 0);
            if (AdjacentType.isUp(above.getType()) && !blockMap.containsKey(above.getLocation())) {
                blockMap.put(above.getLocation(), above);
                blocksToScan.add(above);
                List<Block> affectedAbove = AdjacentTracker.getAffectedBlocksAbove(block);
                for (Block affectedBlock : affectedAbove) {
                    if (blockMap.containsKey(affectedBlock.getLocation())) continue;
                    blockMap.put(affectedBlock.getLocation(), affectedBlock);
                    blocksToScan.add(affectedBlock);
                }
            }
            List<Block> affectedSides = AdjacentTracker.getAffectedBlocksSide(block);
            for (Block affectedBlock : affectedSides) {
                if (blockMap.containsKey(affectedBlock.getLocation())) continue;
                blockMap.put(affectedBlock.getLocation(), affectedBlock);
                blocksToScan.add(affectedBlock);
            }
            if (!material.hasGravity()) continue;
            Block gravityBlock = block.getRelative(0, 1, 0);
            while (gravityBlock.getType().hasGravity() && gravityBlock.getY() < gravityBlock.getWorld().getMaxHeight()) {
                if (!blockMap.containsKey(gravityBlock.getLocation())) {
                    blockMap.put(gravityBlock.getLocation(), gravityBlock);
                    blocksToScan.add(gravityBlock);
                }
                gravityBlock = gravityBlock.getRelative(0, 1, 0);
            }
        }
    }

    static long getPlayerId(@Nullable Player player, long defaultId) {
        if (player == null) {
            return defaultId;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return defaultId;
        }
        return playerProtect.getPlayerId();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        BlockListener.processBlockBreak(block, player, -2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockIgnite(BlockIgniteEvent event) {
        long playerId;
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Location sourceLocation = block.getLocation();
        switch (event.getCause()) {
            case FLINT_AND_STEEL: 
            case FIREBALL: {
                Player player = event.getPlayer();
                if (player != null) {
                    PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
                    playerId = playerProtect != null ? playerProtect.getPlayerId() : -2L;
                    break;
                }
                playerId = PlayerUtils.getPlayerOrEntityId("=fire");
                break;
            }
            case LAVA: {
                if ((block.getType() == Material.FIRE || block.getType().name().contains("FIRE")) && !this.hasBurnableBlocksNearby(block)) {
                    return;
                }
                CallbackSource<Location, Long> lavaSource = this.findNearbyLavaSource(block.getLocation());
                playerId = lavaSource.getPlayerId();
                sourceLocation = lavaSource.getLocation();
                break;
            }
            case LIGHTNING: {
                playerId = PlayerUtils.getPlayerOrEntityId("=lightning");
                break;
            }
            case EXPLOSION: {
                playerId = PlayerUtils.getPlayerOrEntityId("=explosion");
                break;
            }
            default: {
                CallbackSource<Location, Long> fireSource = this.findNearbyFireSource(block.getLocation());
                playerId = fireSource.getPlayerId();
                sourceLocation = fireSource.getLocation();
            }
        }
        BlockSourceCache.registerBlockSource(sourceLocation, playerId, block.getLocation());
        this.processBlockPlace(block, null, playerId);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBurn(BlockBurnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Long playerId = BlockSourceCache.getPlayerId(event.getBlock().getLocation());
        if (playerId == null) {
            playerId = PlayerUtils.getPlayerOrEntityId("=fire");
        }
        BlockListener.processBlockBreak(event.getBlock(), null, playerId);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        for (BlockState state : event.getReplacedBlockStates()) {
            this.processBlockPlace(state.getBlock(), player, -2L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        PlayerProtect playerProtect;
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        long playerId = entity instanceof Player ? ((playerProtect = PlayerProtect.getPlayer((Player)entity)) != null ? playerProtect.getPlayerId() : -2L) : (entity instanceof FallingBlock ? PlayerUtils.getPlayerOrEntityId("=gravity") : (entity.getType() == EntityType.ENDERMAN ? PlayerUtils.getEntityByDirectId("=enderman") : (entity.getType() == EntityType.WITHER ? PlayerUtils.getEntityByDirectId("=wither") : (entity.getType() == EntityType.SILVERFISH ? PlayerUtils.getEntityByDirectId("=silverfish") : PlayerUtils.getEntityByDirectId("=" + entity.getType().name().toLowerCase())))));
        Material to = event.getTo();
        if (to == Material.AIR) {
            BlockListener.processBlockBreak(block, null, playerId);
        } else {
            this.processBlockPlace(block, null, playerId);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block pistonBlock = event.getBlock();
        if (ActionType.BLOCK_BREAK.shouldSkipLog(pistonBlock.getWorld().getName(), "=piston")) {
            return;
        }
        long playerId = PlayerUtils.getPlayerOrEntityId("=piston");
        for (Block block : event.getBlocks()) {
            Location from = block.getLocation();
            Location to = block.getRelative(event.getDirection()).getLocation();
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, from, block, ActionType.BLOCK_BREAK));
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, to, block, ActionType.BLOCK_PLACE));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block pistonBlock = event.getBlock();
        if (ActionType.BLOCK_BREAK.shouldSkipLog(pistonBlock.getWorld().getName(), "=piston")) {
            return;
        }
        long playerId = PlayerUtils.getPlayerOrEntityId("=piston");
        for (Block block : event.getBlocks()) {
            Location from = block.getLocation();
            Location to = block.getRelative(event.getDirection()).getLocation();
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, from, block, ActionType.BLOCK_BREAK));
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, to, block, ActionType.BLOCK_PLACE));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Player player = event.getPlayer();
        this.processBlockPlace(block, player, -2L);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockSpread(BlockSpreadEvent event) {
        long playerId;
        if (event.isCancelled()) {
            return;
        }
        BlockState blockState = event.getBlock().getState();
        BlockState newState = event.getNewState();
        Material newMaterial = newState.getType();
        if (ActionType.BLOCK_PLACE.shouldSkipLog(blockState.getWorld().getName(), newMaterial.name())) {
            return;
        }
        if (BlockTracker.isChorusState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=chorus");
        } else if (BlockTracker.isAmethystState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=amethyst");
        } else if (BlockTracker.isBambooState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=bamboo");
        } else if (BlockTracker.isSculkState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=sculk");
        } else if (BlockTracker.isVineState(newMaterial)) {
            playerId = PlayerUtils.getEntityByDirectId("=vine");
        } else if (newMaterial == Material.FIRE || newMaterial.name().contains("FIRE")) {
            playerId = PlayerUtils.getEntityByDirectId("=fire");
        } else {
            long playerId2 = PlayerUtils.getEntityByDirectId("=natural");
            return;
        }
        this.processBlockStatePlace(event.getBlock().getLocation(), blockState, newState, playerId);
    }

    void processBlockStatePlace(Location location, BlockState blockState, BlockState newState, long playerId) {
        if (newState.getType().equals((Object)Material.AIR) || ActionType.BLOCK_SPREAD.shouldSkipLog(newState.getWorld().getName(), newState.getType().name())) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockStateLogEntry(playerId, location, blockState, newState, ActionType.BLOCK_SPREAD));
    }

    void processBlockPlace(Block block, @Nullable Player player, long defaultId) {
        if (block.getType().equals((Object)Material.AIR) || ActionType.BLOCK_PLACE.shouldSkipLog(block.getWorld().getName(), block.getType().name())) {
            return;
        }
        long playerId = BlockListener.getPlayerId(player, defaultId);
        if (this.plugin.getNexoHook() != null && player != null && this.plugin.getNexoHook().isNexoListener(block, this.plugin.getProtectNMS().getItemInHand(player))) {
            return;
        }
        if (this.plugin.getItemsAdderHook() != null && player != null && this.plugin.getItemsAdderHook().isItemsAdderListener(block, this.plugin.getProtectNMS().getItemInHand(player))) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockLogEntry(playerId, block, ActionType.BLOCK_PLACE));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onLeavesDecay(LeavesDecayEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), "=decay")) {
            return;
        }
        LoggerCache.addLog(new PlayerBlockLogEntry(PlayerUtils.getEntityByDirectId("=decay"), block, ActionType.BLOCK_BREAK));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFurnaceExtract(FurnaceExtractEvent event) {
        Block block = event.getBlock();
        if (ActionType.FURNACE_EXTRACT.shouldSkipLog(block.getWorld().getName(), event.getItemType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(event.getPlayer());
        if (playerProtect == null) {
            return;
        }
        ItemReference itemReference = this.plugin.getItemsManager().getItemReference(new ItemStack(event.getItemType(), event.getItemAmount()));
        LoggerCache.addLog(new PlayerItemLogEntry(playerProtect.getPlayerId(), itemReference, block.getLocation(), ActionType.FURNACE_EXTRACT));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTame(EntityTameEvent event) {
        if (!(event.getOwner() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getOwner();
        if (!(event.getEntity() instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)event.getEntity();
        if (ActionType.TAME.shouldSkipLog(animal.getWorld().getName(), animal.getType().name())) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        LoggerCache.addLog(new PlayerTameEntry(playerProtect.getPlayerId(), (Entity)animal));
    }

    private CallbackSource<Location, Long> findNearbyFireSource(Location location) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        Location checkLoc = location.clone();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    Long playerId;
                    checkLoc.setX(location.getX() + (double)x);
                    checkLoc.setY(location.getY() + (double)y);
                    checkLoc.setZ(location.getZ() + (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    if (checkBlock.getType() != Material.FIRE && !checkBlock.getType().name().contains("FIRE") || (playerId = BlockSourceCache.getPlayerId(checkLoc)) == null) continue;
                    return new CallbackSource<Location, Long>(checkLoc, playerId);
                }
            }
        }
        return new CallbackSource<Location, Long>(checkLoc, PlayerUtils.getPlayerOrEntityId("=fire"));
    }

    private CallbackSource<Location, Long> findNearbyLavaSource(Location location) {
        if (location == null || location.getWorld() == null) {
            return null;
        }
        Location checkLoc = location.clone();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Long playerId;
                    checkLoc.setX(location.getX() + (double)x);
                    checkLoc.setY(location.getY() + (double)y);
                    checkLoc.setZ(location.getZ() + (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    if (checkBlock.getType() != Material.LAVA && !checkBlock.getType().name().contains("LAVA") || (playerId = BlockSourceCache.getPlayerId(checkLoc)) == null) continue;
                    return new CallbackSource<Location, Long>(checkLoc, playerId);
                }
            }
        }
        return new CallbackSource<Location, Long>(checkLoc, PlayerUtils.getPlayerOrEntityId("=lava"));
    }

    private boolean hasBurnableBlocksNearby(Block block) {
        int[][] offsets;
        if (block == null || block.getWorld() == null) {
            return false;
        }
        Location location = block.getLocation();
        for (int[] offset : offsets = new int[][]{{0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}}) {
            Block checkBlock;
            Location checkLoc = location.clone().add((double)offset[0], (double)offset[1], (double)offset[2]);
            if (checkLoc.getY() < 0.0 || checkLoc.getY() >= (double)block.getWorld().getMaxHeight() || !(checkBlock = checkLoc.getBlock()).getType().isBurnable()) continue;
            return true;
        }
        return false;
    }
}

