/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.BlockSourceCache;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockStateLogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.managers.ConfigManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;

public class BlockFormListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final ConfigManager configManager = this.plugin.getConfigManager();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        Block block = event.getBlock();
        BlockState newState = event.getNewState();
        Material newType = newState.getType();
        if (!this.configManager.isLiquidTracking()) {
            return;
        }
        try {
            Long cachedPlayerId;
            long playerId;
            boolean shouldLog;
            boolean bl = shouldLog = newType == Material.OBSIDIAN || newType == Material.COBBLESTONE || newType == Material.STONE || newType.name().endsWith("CONCRETE");
            if (shouldLog && (playerId = (cachedPlayerId = BlockSourceCache.getPlayerId(block.getLocation())) == null ? this.findLiquidSourcePlayer(block) : cachedPlayerId.longValue()) != -2L) {
                PlayerBlockStateLogEntry blockStateLogEntry = new PlayerBlockStateLogEntry(playerId, block.getState(), newState, ActionType.BLOCK_PLACE);
                LoggerCache.addLog(blockStateLogEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long findLiquidSourcePlayer(Block block) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        World world = block.getWorld();
        Location[] adjacentLocations = new Location[]{new Location(world, (double)(x + 1), (double)y, (double)z), new Location(world, (double)(x - 1), (double)y, (double)z), new Location(world, (double)x, (double)y, (double)(z + 1)), new Location(world, (double)x, (double)y, (double)(z - 1))};
        for (Location location : adjacentLocations) {
            Block adjacentBlock;
            Material adjacentType;
            Block adjacentBlock2;
            Material adjacentType2;
            Long cachedPlayerId = BlockSourceCache.getPlayerId(location);
            if (cachedPlayerId != null && this.isLiquid(adjacentType2 = (adjacentBlock2 = world.getBlockAt(location)).getType())) {
                return cachedPlayerId;
            }
            LogEntry logEntry = LoggerCache.getPlacedBlockLog(location);
            if (logEntry == null || !this.isLiquid(adjacentType = (adjacentBlock = world.getBlockAt(location)).getType())) continue;
            return logEntry.getPlayerId();
        }
        return -2L;
    }

    private boolean isLiquid(Material material) {
        String name = material.name();
        return material == Material.WATER || material == Material.LAVA || name.equals("STATIONARY_WATER") || name.equals("STATIONARY_LAVA");
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block fromBlock = event.getBlock();
        Block toBlock = event.getToBlock();
        Material fromType = fromBlock.getType();
        Material toType = toBlock.getType();
        World world = fromBlock.getWorld();
        if (!this.isLiquid(fromType)) {
            if (fromType == Material.DRAGON_EGG) {
                this.handleDragonEggTeleport(fromBlock, toBlock);
            }
            return;
        }
        if (!this.configManager.isLiquidTracking()) {
            return;
        }
        try {
            long playerId;
            Long cachedPlayerId = BlockSourceCache.getPlayerId(fromBlock.getLocation());
            if (cachedPlayerId != null) {
                playerId = cachedPlayerId;
            } else {
                LogEntry logEntry = LoggerCache.getPlacedBlockLog(fromBlock.getLocation());
                if (logEntry != null) {
                    playerId = logEntry.getPlayerId();
                } else {
                    long l = playerId = fromType == Material.WATER ? -4L : -5L;
                }
            }
            if (toType == Material.AIR || toType.name().equals("CAVE_AIR")) {
                if (ActionType.BLOCK_PLACE.shouldSkipLog(world.getName(), fromType.name())) {
                    return;
                }
                BlockSourceCache.registerBlockSource(toBlock.getLocation(), playerId);
                PlayerBlockLogEntry entry = new PlayerBlockLogEntry(playerId, toBlock.getLocation(), fromBlock, ActionType.BLOCK_PLACE);
                LoggerCache.addLog(entry);
            } else {
                if (ActionType.BLOCK_BREAK.shouldSkipLog(world.getName(), toType.name())) {
                    return;
                }
                PlayerBlockLogEntry breakEntry = new PlayerBlockLogEntry(playerId, toBlock, ActionType.BLOCK_BREAK);
                LoggerCache.addLog(breakEntry);
                BlockSourceCache.registerBlockSource(toBlock.getLocation(), playerId);
                PlayerBlockLogEntry placeEntry = new PlayerBlockLogEntry(playerId, toBlock.getLocation(), fromBlock, ActionType.BLOCK_PLACE);
                LoggerCache.addLog(placeEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleDragonEggTeleport(Block fromBlock, Block toBlock) {
        long playerId = -1L;
        try {
            if (!ActionType.BLOCK_BREAK.shouldSkipLog(fromBlock.getWorld().getName(), Material.DRAGON_EGG.name())) {
                PlayerBlockLogEntry breakEntry = new PlayerBlockLogEntry(playerId, fromBlock, ActionType.BLOCK_BREAK);
                LoggerCache.addLog(breakEntry);
            }
            if (!ActionType.BLOCK_PLACE.shouldSkipLog(toBlock.getWorld().getName(), Material.DRAGON_EGG.name())) {
                PlayerBlockLogEntry placeEntry = new PlayerBlockLogEntry(playerId, toBlock.getLocation(), toBlock, ActionType.BLOCK_PLACE);
                LoggerCache.addLog(placeEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

