/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.QueuedLog;
import io.github.insideranh.stellarprotect.utils.Debugger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class SQLQueueConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final AtomicLong lastProcessedId = new AtomicLong(0L);
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private Connection connection;
    private PreparedStatement insertStatement;

    public void connect() {
        try {
            File dbFile = new File(this.stellarProtect.getDataFolder(), "temp_queue.db");
            if (!dbFile.exists()) {
                dbFile.getParentFile().mkdirs();
                dbFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile);
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA synchronous = OFF");
                stmt.execute("PRAGMA journal_mode = MEMORY");
                stmt.execute("PRAGMA temp_store = MEMORY");
                stmt.execute("PRAGMA locking_mode = EXCLUSIVE");
                stmt.execute("PRAGMA cache_size = -32000");
                stmt.execute("PRAGMA count_changes = OFF");
                stmt.execute("PRAGMA auto_vacuum = NONE");
                stmt.execute("PRAGMA page_size = 8192");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Failed to configure SQLite for maximum performance");
                e.printStackTrace();
            }
            try (Statement statement = this.connection.createStatement();){
                String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + logEntriesTable + " (id INTEGER PRIMARY KEY AUTOINCREMENT,player_id INTEGER,world_id INTEGER,x REAL,y REAL,z REAL,action_type INTEGER,restored INTEGER DEFAULT 0,extra_json TEXT,created_at INTEGER)");
            }
            catch (Exception exception) {
                this.stellarProtect.getLogger().warning("Error creating queue table: " + exception.getMessage());
                exception.printStackTrace();
                return;
            }
            this.connection.setAutoCommit(false);
            String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
            this.insertStatement = this.connection.prepareStatement("INSERT INTO " + logEntriesTable + " (player_id, world_id, x, y, z, action_type, restored, extra_json, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.stellarProtect.getLogger().info("Queue database connected.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to SQLite queue database: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void save(List<LogEntry> logEntries) {
        if (logEntries == null || logEntries.isEmpty()) {
            return;
        }
        this.singleThreadExecutor.execute(() -> {
            long startTime = System.currentTimeMillis();
            try {
                for (LogEntry logEntry : logEntries) {
                    String extraJson = logEntry.toSaveJson();
                    this.insertStatement.setLong(1, logEntry.getPlayerId());
                    this.insertStatement.setInt(2, logEntry.getWorldId());
                    this.insertStatement.setDouble(3, logEntry.getX());
                    this.insertStatement.setDouble(4, logEntry.getY());
                    this.insertStatement.setDouble(5, logEntry.getZ());
                    this.insertStatement.setInt(6, logEntry.getActionType());
                    this.insertStatement.setInt(7, 0);
                    this.insertStatement.setString(8, extraJson);
                    this.insertStatement.setLong(9, System.currentTimeMillis());
                    this.insertStatement.addBatch();
                }
                this.insertStatement.executeBatch();
                this.connection.commit();
                Debugger.debugSave("Flushed " + logEntries.size() + " logs to queue in " + (System.currentTimeMillis() - startTime) + " ms");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Error flushing queue: " + e.getMessage());
                e.printStackTrace();
                try {
                    this.connection.rollback();
                }
                catch (SQLException ex) {
                    this.stellarProtect.getLogger().warning("Error rolling back: " + ex.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueuedLog> getLogs(int maxLogs) {
        ArrayList<QueuedLog> logs = new ArrayList<QueuedLog>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
            long currentLastId = this.lastProcessedId.get();
            stmt = this.connection.prepareStatement("SELECT * FROM " + logEntriesTable + " WHERE id > ? ORDER BY id LIMIT ?");
            stmt.setLong(1, currentLastId);
            stmt.setInt(2, maxLogs);
            rs = stmt.executeQuery();
            long maxId = currentLastId;
            while (rs.next()) {
                long id = rs.getLong("id");
                maxId = Math.max(maxId, id);
                QueuedLog log = QueuedLog.builder().id(id).playerId(rs.getLong("player_id")).worldId(rs.getInt("world_id")).x(rs.getDouble("x")).y(rs.getDouble("y")).z(rs.getDouble("z")).actionType(rs.getInt("action_type")).restored(rs.getInt("restored") == 1).extraJson(rs.getString("extra_json")).createdAt(rs.getLong("created_at")).build();
                logs.add(log);
            }
            if (!logs.isEmpty()) {
                this.lastProcessedId.set(maxId);
                Debugger.debugSave("Fetched " + logs.size() + " logs from queue (IDs " + ((QueuedLog)logs.get(0)).getId() + " to " + maxId + ")");
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error getting logs from queue: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Error closing resources: " + e.getMessage());
            }
        }
        return logs;
    }

    public void deleteProcessedLogs(long maxId) {
        this.singleThreadExecutor.execute(() -> {
            Statement stmt = null;
            Statement countStmt = null;
            ResultSet countRs = null;
            try {
                String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
                stmt = this.connection.prepareStatement("DELETE FROM " + logEntriesTable + " WHERE id <= ?");
                stmt.setLong(1, maxId);
                int deleted = stmt.executeUpdate();
                this.connection.commit();
                if (deleted > 0) {
                    Debugger.debugSave("Deleted " + deleted + " processed logs from queue (up to ID " + maxId + ")");
                }
                countStmt = this.connection.prepareStatement("SELECT COUNT(*) as remaining FROM " + logEntriesTable);
                countRs = countStmt.executeQuery();
                int remaining = 0;
                if (countRs.next()) {
                    remaining = countRs.getInt("remaining");
                }
                Debugger.debugSave(remaining + " logs remaining in queue");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Error deleting processed logs: " + e.getMessage());
                e.printStackTrace();
                try {
                    if (this.connection != null) {
                        this.connection.rollback();
                    }
                }
                catch (SQLException ex) {
                    this.stellarProtect.getLogger().warning("Error rolling back delete: " + ex.getMessage());
                }
            }
            finally {
                try {
                    if (countRs != null) {
                        countRs.close();
                    }
                    if (countStmt != null) {
                        countStmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    this.stellarProtect.getLogger().warning("Error closing resources: " + e.getMessage());
                }
            }
        });
    }

    public void close() {
        try {
            this.singleThreadExecutor.shutdown();
            if (!this.singleThreadExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.stellarProtect.getLogger().warning("Executor did not terminate in time, forcing shutdown...");
                this.singleThreadExecutor.shutdownNow();
            }
            if (this.insertStatement != null && !this.insertStatement.isClosed()) {
                this.insertStatement.close();
            }
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
                this.connection.close();
            }
            this.stellarProtect.getLogger().info("Queue database closed.");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().warning("Error on close SQLite connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Generated
    public AtomicLong getLastProcessedId() {
        return this.lastProcessedId;
    }

    @Generated
    public ExecutorService getSingleThreadExecutor() {
        return this.singleThreadExecutor;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }

    @Generated
    public PreparedStatement getInsertStatement() {
        return this.insertStatement;
    }
}

