/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.BlocksRepository;
import io.github.insideranh.stellarprotect.database.repositories.DatabaseConnection;
import io.github.insideranh.stellarprotect.database.repositories.IdsRepository;
import io.github.insideranh.stellarprotect.database.repositories.ItemsRepository;
import io.github.insideranh.stellarprotect.database.repositories.LoggerRepository;
import io.github.insideranh.stellarprotect.database.repositories.PlayerRepository;
import io.github.insideranh.stellarprotect.database.repositories.RestoreRepository;
import io.github.insideranh.stellarprotect.database.types.sql.BlocksRepositorySQL;
import io.github.insideranh.stellarprotect.database.types.sql.IdsRepositorySQL;
import io.github.insideranh.stellarprotect.database.types.sql.ItemsRepositorySQL;
import io.github.insideranh.stellarprotect.database.types.sql.LoggerRepositorySQL;
import io.github.insideranh.stellarprotect.database.types.sql.PlayerRepositorySQL;
import io.github.insideranh.stellarprotect.database.types.sql.RestoreRepositorySQL;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

public class SQLConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private RestoreRepository restoreRepository;
    private BlocksRepository blocksRepository;
    private Connection connection;

    @Override
    public void connect() {
        try {
            File dbFile = new File(this.stellarProtect.getDataFolder(), this.stellarProtect.getConfig().getString("databases.h2.database") + ".db");
            if (!dbFile.exists()) {
                dbFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile);
            try (Statement statement = this.connection.createStatement();){
                String playersTable = this.stellarProtect.getConfigManager().getTablesPlayers();
                String worldsTable = this.stellarProtect.getConfigManager().getTablesWorlds();
                String entityIdsTable = this.stellarProtect.getConfigManager().getTablesEntityIds();
                String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
                String idCounterTable = this.stellarProtect.getConfigManager().getTablesIdCounter();
                String itemTemplatesTable = this.stellarProtect.getConfigManager().getTablesItemTemplates();
                String blockTemplatesTable = this.stellarProtect.getConfigManager().getTablesBlockTemplates();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + playersTable + " (id BIGINT PRIMARY KEY,uuid VARCHAR(36) NOT NULL,name VARCHAR(36),realname VARCHAR(36))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + worldsTable + " (id INT PRIMARY KEY,name TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + entityIdsTable + " (id BIGINT PRIMARY KEY,entityType TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + logEntriesTable + " (id INTEGER PRIMARY KEY AUTOINCREMENT,player_id BIGINT,world_id INT,x DECIMAL(8, 2),y DECIMAL(8, 2),z DECIMAL(8, 2),action_type INT,restored TINYINT DEFAULT 0,extra_json TEXT,created_at BIGINT,FOREIGN KEY (player_id) REFERENCES " + playersTable + "(id),FOREIGN KEY (world_id) REFERENCES " + worldsTable + "(id))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + idCounterTable + " (table_name TEXT PRIMARY KEY,current_id BIGINT)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + itemTemplatesTable + " (id INTEGER PRIMARY KEY,base64 TEXT,hash INTEGER,s TINYINT,access_count INTEGER DEFAULT 0,last_accessed TIMESTAMP DEFAULT CURRENT_TIMESTAMP,total_quantity_used INTEGER DEFAULT 0,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + blockTemplatesTable + " (id INT PRIMARY KEY,block_data TEXT)");
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + logEntriesTable);
                if (resultSet.next()) {
                    long count = resultSet.getLong("COUNT(*)");
                    PlayerUtils.setNextLogId(count);
                    this.stellarProtect.getLogger().info("Next log ID: " + count);
                }
            }
            catch (Exception exception) {
                this.stellarProtect.getLogger().warning("Error on connect to SQLite database " + exception.getMessage());
                exception.printStackTrace();
                return;
            }
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA journal_mode = WAL");
                stmt.execute("PRAGMA synchronous = NORMAL");
                stmt.execute("PRAGMA cache_size = 10000");
                stmt.execute("PRAGMA temp_store = MEMORY");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Failed to configure SQLite for performance");
            }
            this.playerRepository = new PlayerRepositorySQL(this.connection);
            this.loggerRepository = new LoggerRepositorySQL(this.connection);
            this.idsRepository = new IdsRepositorySQL(this.connection);
            this.itemsRepository = new ItemsRepositorySQL(this.connection);
            this.restoreRepository = new RestoreRepositorySQL(this.connection);
            this.blocksRepository = new BlocksRepositorySQL(this.connection);
            this.stellarProtect.getLogger().info("Connected to SQLite database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to SQLite database " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    public void createIndexes() {
        String logEntries = this.stellarProtect.getConfigManager().getTablesLogEntries();
        String players = this.stellarProtect.getConfigManager().getTablesPlayers();
        try (Statement stmt = this.connection.createStatement();){
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_query_main;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_log_entries_optimized;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_action_time_coords;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_log_entries_filtering;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_query_optimized;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_covering_query;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_coords_time;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_item_hash;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_item_access_count;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_item_last_accessed;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("DROP INDEX IF EXISTS idx_item_total_used;");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS idx_location_time_lookup ON " + logEntries + " (created_at DESC, x, y, z, action_type)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_time ON " + logEntries + " (player_id, created_at)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS idx_world_time ON " + logEntries + " (world_id, created_at)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS idx_time_action ON " + logEntries + " (created_at, action_type)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute("CREATE INDEX IF NOT EXISTS idx_players_id ON " + players + " (id)");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Failed to create indexes: " + e.getMessage());
        }
        this.updateTables();
    }

    public void updateTables() {
        Statement stmt2;
        String logEntries = this.stellarProtect.getConfigManager().getTablesLogEntries();
        String players = this.stellarProtect.getConfigManager().getTablesPlayers();
        String itemTemplates = this.stellarProtect.getConfigManager().getTablesItemTemplates();
        try {
            stmt2 = this.connection.createStatement();
            try {
                stmt2.execute("ALTER TABLE " + players + " ADD COLUMN realname VARCHAR(36);");
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        catch (SQLException stmt2) {
            // empty catch block
        }
        try {
            stmt2 = this.connection.createStatement();
            try {
                stmt2.execute("ALTER TABLE " + itemTemplates + " ADD COLUMN hash INTEGER;");
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        catch (SQLException stmt3) {
            // empty catch block
        }
        try {
            stmt2 = this.connection.createStatement();
            try {
                stmt2.execute("ALTER TABLE " + logEntries + " ADD COLUMN restored TINYINT DEFAULT 0;");
            }
            finally {
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on close SQLite connection: " + e.getMessage());
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }

    @Override
    @Generated
    public BlocksRepository getBlocksRepository() {
        return this.blocksRepository;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }
}

