/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.BlocksRepository;
import io.github.insideranh.stellarprotect.database.repositories.DatabaseConnection;
import io.github.insideranh.stellarprotect.database.repositories.IdsRepository;
import io.github.insideranh.stellarprotect.database.repositories.ItemsRepository;
import io.github.insideranh.stellarprotect.database.repositories.LoggerRepository;
import io.github.insideranh.stellarprotect.database.repositories.PlayerRepository;
import io.github.insideranh.stellarprotect.database.repositories.RestoreRepository;
import io.github.insideranh.stellarprotect.database.types.mysql.BlocksRepositoryMySQL;
import io.github.insideranh.stellarprotect.database.types.mysql.IdsRepositoryMySQL;
import io.github.insideranh.stellarprotect.database.types.mysql.ItemsRepositoryMySQL;
import io.github.insideranh.stellarprotect.database.types.mysql.LoggerRepositoryMySQL;
import io.github.insideranh.stellarprotect.database.types.mysql.PlayerRepositoryMySQL;
import io.github.insideranh.stellarprotect.database.types.mysql.RestoreRepositoryMySQL;
import io.github.insideranh.stellarprotect.libs.hikaricp.HikariConfig;
import io.github.insideranh.stellarprotect.libs.hikaricp.HikariDataSource;
import io.github.insideranh.stellarprotect.utils.Debugger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

public class MySQLConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private BlocksRepository blocksRepository;
    private RestoreRepository restoreRepository;
    private HikariDataSource dataSource;

    @Override
    public void connect() {
        try {
            HikariConfig config = new HikariConfig();
            boolean useSSL = this.stellarProtect.getConfig().getBoolean("databases.mysql.useSSL", false);
            String url = "jdbc:mysql://" + this.stellarProtect.getConfig().getString("databases.mysql.host") + ":" + this.stellarProtect.getConfig().getInt("databases.mysql.port") + "/" + this.stellarProtect.getConfig().getString("databases.mysql.database") + "?autoReconnect=true";
            this.stellarProtect.getLogger().info("Connecting to MySQL database with url: " + url);
            config.setDriverClassName("com.mysql.jdbc.Driver");
            config.setJdbcUrl(url);
            config.setUsername(this.stellarProtect.getConfig().getString("databases.mysql.user"));
            config.setPassword(this.stellarProtect.getConfig().getString("databases.mysql.password", ""));
            config.addDataSourceProperty("cachePrepStmts", true);
            config.addDataSourceProperty("prepStmtCacheSize", 250);
            config.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
            config.addDataSourceProperty("useServerPrepStmts", true);
            config.addDataSourceProperty("useLocalSessionState", true);
            config.addDataSourceProperty("rewriteBatchedStatements", true);
            config.addDataSourceProperty("cacheResultSetMetadata", true);
            config.addDataSourceProperty("cacheServerConfiguration", true);
            config.addDataSourceProperty("elideSetAutoCommits", true);
            config.addDataSourceProperty("maintainTimeStats", false);
            config.addDataSourceProperty("characterEncoding", "utf8");
            config.addDataSourceProperty("encoding", "UTF-8");
            config.addDataSourceProperty("useUnicode", "true");
            config.addDataSourceProperty("useSSL", useSSL);
            config.addDataSourceProperty("tcpKeepAlive", true);
            config.setMaxLifetime(Long.MAX_VALUE);
            config.setMinimumIdle(0);
            config.setIdleTimeout(30000L);
            config.setConnectionTimeout(10000L);
            config.setMaximumPoolSize(10);
            this.dataSource = new HikariDataSource(config);
            try (Connection connection = this.dataSource.getConnection();){
                String playersTable = this.stellarProtect.getConfigManager().getTablesPlayers();
                String worldsTable = this.stellarProtect.getConfigManager().getTablesWorlds();
                String entityIdsTable = this.stellarProtect.getConfigManager().getTablesEntityIds();
                String logEntriesTable = this.stellarProtect.getConfigManager().getTablesLogEntries();
                String idCounterTable = this.stellarProtect.getConfigManager().getTablesIdCounter();
                String itemTemplatesTable = this.stellarProtect.getConfigManager().getTablesItemTemplates();
                String blockTemplatesTable = this.stellarProtect.getConfigManager().getTablesBlockTemplates();
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + playersTable + " (id BIGINT PRIMARY KEY,uuid VARCHAR(36) NOT NULL,name VARCHAR(36))");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + worldsTable + " (id INT PRIMARY KEY,name TEXT NOT NULL)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + entityIdsTable + " (id BIGINT PRIMARY KEY,entityType TEXT NOT NULL)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + logEntriesTable + " (id BIGINT AUTO_INCREMENT PRIMARY KEY,player_id BIGINT,world_id INT,x DECIMAL(8, 2),y DECIMAL(8, 2),z DECIMAL(8, 2),action_type INT,restored TINYINT DEFAULT 0,extra_json TEXT,created_at BIGINT)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + idCounterTable + " (table_name VARCHAR(64) PRIMARY KEY,current_id INTEGER)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + itemTemplatesTable + " (id BIGINT PRIMARY KEY,base64 TEXT,s TINYINT,access_count INTEGER DEFAULT 0,last_accessed TIMESTAMP DEFAULT CURRENT_TIMESTAMP,total_quantity_used INTEGER DEFAULT 0,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + blockTemplatesTable + " (id INT PRIMARY KEY,block_data TEXT)");
                    statement.execute("SET SESSION foreign_key_checks = 0");
                    statement.execute("SET SESSION unique_checks = 0");
                }
            }
            this.playerRepository = new PlayerRepositoryMySQL(this.dataSource);
            this.loggerRepository = new LoggerRepositoryMySQL(this.dataSource);
            this.idsRepository = new IdsRepositoryMySQL(this.dataSource);
            this.itemsRepository = new ItemsRepositoryMySQL(this.dataSource);
            this.blocksRepository = new BlocksRepositoryMySQL(this.dataSource);
            this.restoreRepository = new RestoreRepositoryMySQL(this.dataSource);
            this.stellarProtect.getLogger().info("Connected to MySQL database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to MySQL database. " + exception.getMessage());
        }
    }

    @Override
    public void createIndexes() {
        String logEntries = this.stellarProtect.getConfigManager().getTablesLogEntries();
        String itemTemplates = this.stellarProtect.getConfigManager().getTablesItemTemplates();
        String players = this.stellarProtect.getConfigManager().getTablesPlayers();
        try (Connection connection = this.dataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.execute("DROP INDEX idx_query_main ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_log_entries_optimized ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_action_time_coords ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_log_entries_filtering ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_query_optimized ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_covering_query ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_coords_time ON " + logEntries + ";");
            stmt.execute("DROP INDEX idx_item_hash ON " + itemTemplates + ";");
            stmt.execute("DROP INDEX idx_item_access_count ON " + itemTemplates + ";");
            stmt.execute("DROP INDEX idx_item_last_accessed ON " + itemTemplates + ";");
            stmt.execute("DROP INDEX idx_item_total_used ON " + itemTemplates + ";");
            stmt.execute("CREATE INDEX idx_location_time_lookup ON " + logEntries + " (created_at DESC, x, y, z, action_type)");
            stmt.execute("CREATE INDEX idx_player_time ON " + logEntries + " (player_id, created_at)");
            stmt.execute("CREATE INDEX idx_world_time ON " + logEntries + " (world_id, created_at)");
            stmt.execute("CREATE INDEX idx_time_action ON " + logEntries + " (created_at, action_type)");
            stmt.execute("CREATE INDEX idx_players_id ON " + players + " (id)");
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Failed to create indexes: " + e.getMessage());
        }
        this.updateTables();
    }

    public void updateTables() {
        String logEntries = this.stellarProtect.getConfigManager().getTablesLogEntries();
        String players = this.stellarProtect.getConfigManager().getTablesPlayers();
        String itemTemplates = this.stellarProtect.getConfigManager().getTablesItemTemplates();
        try (Connection connection = this.dataSource.getConnection();){
            try (Statement stmt = connection.createStatement();){
                stmt.execute("ALTER TABLE " + players + " ADD COLUMN realname VARCHAR(36);");
            }
            stmt = connection.createStatement();
            try {
                stmt.execute("ALTER TABLE " + itemTemplates + " ADD COLUMN hash BIGINT;");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            stmt = connection.createStatement();
            try {
                stmt.execute("ALTER TABLE " + logEntries + " ADD COLUMN restored TINYINT DEFAULT 0;");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            Debugger.debugExtras("The realname and hash column already exists, ignoring...");
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public BlocksRepository getBlocksRepository() {
        return this.blocksRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }

    @Generated
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

