/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.enums.TeleportType;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerTeleportLogEntry
extends LogEntry {
    private final float yaw;
    private final float pitch;
    private final int teleportType;

    public PlayerTeleportLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.yaw = jsonObject.has("y") ? jsonObject.get("y").getAsFloat() : 0.0f;
        this.pitch = jsonObject.has("p") ? jsonObject.get("p").getAsFloat() : 0.0f;
        this.teleportType = jsonObject.has("t") ? jsonObject.get("t").getAsInt() : TeleportType.UNKNOWN.getId();
    }

    public PlayerTeleportLogEntry(long playerId, Location location, TeleportType teleportType) {
        super(playerId, ActionType.TELEPORT.getId(), location, System.currentTimeMillis());
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        this.teleportType = teleportType.getId();
    }

    @Override
    public String getDataString() {
        return TeleportType.getById(this.teleportType).name();
    }

    @Override
    public String toSaveJson() {
        return "{\"y\":" + this.yaw + ",\"p\":" + this.pitch + ",\"t\":" + this.teleportType + "}";
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public int getTeleportType() {
        return this.teleportType;
    }
}

