/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.data;

import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.entity.Player;

public class UndoSession {
    private final Player player;
    private final DatabaseFilters databaseFilters;
    private final HashMap<Integer, Object> processedLogHashes;
    private final HashMap<Integer, Object> undoneLogHashes;
    private final int logsPerPage;
    private int currentOffset;
    private boolean verbose;
    private boolean silent;

    public UndoSession(Player player, DatabaseFilters databaseFilters, boolean verbose, boolean silent) {
        this.player = player;
        this.databaseFilters = databaseFilters;
        this.processedLogHashes = new HashMap();
        this.undoneLogHashes = new HashMap();
        this.logsPerPage = 10;
        this.currentOffset = 0;
        this.verbose = verbose;
        this.silent = silent;
    }

    public void addProcessedLog(int logHash, Object logEntry) {
        this.processedLogHashes.put(logHash, logEntry);
    }

    public void markAsUndone(int logHash, Object logEntry) {
        this.undoneLogHashes.put(logHash, logEntry);
    }

    public void unmarkUndone(int logHash) {
        this.undoneLogHashes.remove(logHash);
    }

    public boolean isUndone(int logHash) {
        return this.undoneLogHashes.containsKey(logHash);
    }

    public boolean isProcessed(int logHash) {
        return this.processedLogHashes.containsKey(logHash);
    }

    public Object getProcessedLog(int logHash) {
        return this.processedLogHashes.get(logHash);
    }

    public Object getUndoneLog(int logHash) {
        return this.undoneLogHashes.get(logHash);
    }

    public void nextPage() {
        this.currentOffset += this.logsPerPage;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public DatabaseFilters getDatabaseFilters() {
        return this.databaseFilters;
    }

    @Generated
    public HashMap<Integer, Object> getProcessedLogHashes() {
        return this.processedLogHashes;
    }

    @Generated
    public HashMap<Integer, Object> getUndoneLogHashes() {
        return this.undoneLogHashes;
    }

    @Generated
    public int getLogsPerPage() {
        return this.logsPerPage;
    }

    @Generated
    public int getCurrentOffset() {
        return this.currentOffset;
    }

    @Generated
    public boolean isVerbose() {
        return this.verbose;
    }

    @Generated
    public boolean isSilent() {
        return this.silent;
    }

    @Generated
    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    @Generated
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Generated
    public void setSilent(boolean silent) {
        this.silent = silent;
    }
}

