/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments.lookups;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.ArgumentsParser;
import io.github.insideranh.stellarprotect.arguments.DatabaseFilters;
import io.github.insideranh.stellarprotect.arguments.PageArg;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.arguments.UsersArg;
import io.github.insideranh.stellarprotect.cache.BlocksCache;
import io.github.insideranh.stellarprotect.cache.ItemsCache;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.LookupSession;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LookupArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PageArg pageArg = ArgumentsParser.parsePage(arguments);
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        RadiusArg radiusArg = ArgumentsParser.parseRadiusOrNull(player, arguments, player.getLocation());
        List<ActionType> actionTypesArg = ArgumentsParser.parseActionTypes(arguments);
        List<String> includesArg = ArgumentsParser.parseIncludesMaterials(arguments);
        List<String> excludesArg = ArgumentsParser.parseExcludesMaterials(arguments);
        List<String> includesEntitiesArg = ArgumentsParser.parseIncludesEntities(arguments);
        List<String> excludesEntitiesArg = ArgumentsParser.parseExcludesEntities(arguments);
        Map<String, List<String>> includesMap = ArgumentsParser.parseIncludeMaterials(arguments);
        Map<String, List<String>> excludesMap = ArgumentsParser.parseExcludeMaterials(arguments);
        if (playerProtect.getNextLookup() > System.currentTimeMillis()) {
            this.plugin.getLangManager().sendMessage(sender, "messages.waitingForLookup");
            return;
        }
        playerProtect.setNextLookup(System.currentTimeMillis() + 5000L);
        ItemsCache itemsCache = StellarProtect.getInstance().getItemsManager().getItemCache();
        BlocksCache blocksCache = StellarProtect.getInstance().getBlocksManager().getBlocksCache();
        ArgumentsParser.parseUsers(arguments).thenAccept(usersArg -> {
            DatabaseFilters databaseFilters = new DatabaseFilters();
            databaseFilters.setTimeFilter(timeArg);
            databaseFilters.setRadiusFilter(radiusArg);
            databaseFilters.setPageFilter(pageArg);
            databaseFilters.setAllIncludeFilters(itemsCache.findIdsByTypeNameContains(includesArg, ItemsCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setAllExcludeFilters(itemsCache.findIdsByTypeNameContains(excludesArg, ItemsCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setIncludeBlockFilters(blocksCache.findIdsByTypeNameContains(includesArg, BlocksCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setExcludeBlockFilters(blocksCache.findIdsByTypeNameContains(excludesArg, BlocksCache.FieldType.LOWER_TYPE_NAME));
            databaseFilters.setIncludeMaterialFilters(itemsCache.findIdsContains(includesMap));
            databaseFilters.setExcludeMaterialFilters(itemsCache.findIdsContains(excludesMap));
            databaseFilters.setIncludeEntityFilters(includesEntitiesArg);
            databaseFilters.setExcludeEntityFilters(excludesEntitiesArg);
            databaseFilters.setActionTypesFilter(actionTypesArg.stream().map(ActionType::getId).collect(Collectors.toCollection(ArrayList::new)));
            databaseFilters.setUserFilters((UsersArg)usersArg);
            playerProtect.getPosibleLogs().clear();
            playerProtect.setInspectSession(null);
            playerProtect.setLookupSession(new LookupSession(pageArg, databaseFilters, 0, 10));
            this.plugin.getLangManager().sendMessage(sender, "messages.actions.lookup");
            ((CompletableFuture)this.plugin.getProtectDatabase().getLogs(databaseFilters, databaseFilters.isIgnoreCache(), pageArg.getSkip(), pageArg.getLimit()).thenAccept(callbackLookup -> {
                Map groupedLogs = (Map)callbackLookup.getLogs();
                long total = (long)Math.ceil((double)((Long)callbackLookup.getTotal()).longValue() / (double)pageArg.getPerPage());
                playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
                for (Map.Entry entry : groupedLogs.entrySet()) {
                    LocationCache location = (LocationCache)entry.getKey();
                    Set logs = (Set)entry.getValue();
                    for (LogEntry logEntry : logs) {
                        ActionType actionType = ActionType.getById(logEntry.getActionType());
                        if (actionType == null) continue;
                        this.plugin.getInspectHandler().processLogEntry(player, logEntry);
                    }
                    this.plugin.getProtectNMS().sendActionTitle(player, this.plugin.getLangManager().get("messages.actions.location"), "\u00a7fClick to teleport!", "/stellarprotect t " + WorldUtils.getWorld(location.getWorldId()) + " " + location.getX() + " " + location.getY() + " " + location.getZ(), text -> text.replace("<location>", WorldUtils.getFormatedLocation(location)));
                }
                this.plugin.getProtectNMS().sendPageButtons(player, this.plugin.getLangManager().get("messages.pagesNav"), this.plugin.getLangManager().get("messages.clickPage"), pageArg.getPage(), pageArg.getPerPage(), (int)total);
            })).exceptionally(error -> {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
                playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
                error.printStackTrace();
                Debugger.debugLog("Error on lookup: " + error.getMessage());
                return null;
            });
        });
    }
}

