/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments.lookups;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class InspectArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        Player player;
        if (!(sender instanceof Player) && arguments.length < 2) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayers");
            return;
        }
        Player player2 = player = arguments.length > 1 && sender.hasPermission("stellarprotect.inspect.others") ? this.plugin.getServer().getPlayer(arguments[1]) : (Player)sender;
        if (player == null) {
            this.plugin.getLangManager().sendMessage(sender, "messages.offlinePlayer");
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            this.plugin.getLangManager().sendMessage(sender, "messages.noPlayer");
            return;
        }
        playerProtect.setInspect(!playerProtect.isInspect());
        playerProtect.getPosibleLogs().clear();
        playerProtect.setInspectSession(null);
        playerProtect.setLookupSession(null);
        this.plugin.getLangManager().sendMessage(sender, "messages.inspect." + (playerProtect.isInspect() ? "enable" : "disable"));
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new ArrayList<String>();
    }
}

