/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments.basic;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class DebugArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        String debugType;
        if (arguments.length < 1) {
            this.plugin.getLangManager().sendMessage(sender, "messages.noDebug");
            return;
        }
        switch (debugType = arguments[0].toLowerCase()) {
            case "save": {
                boolean newState = !this.plugin.getConfigManager().isDebugSave();
                this.plugin.getConfig().set("debugs.save", (Object)newState);
                this.plugin.saveConfig();
                this.plugin.getConfigManager().setDebugSave(newState);
                this.plugin.getLangManager().sendMessage(sender, "messages.debugSave", text -> text.replace("<state>", newState ? "on" : "off"));
                break;
            }
            case "log": {
                boolean newState = !this.plugin.getConfigManager().isDebugLog();
                this.plugin.getConfig().set("debugs.log", (Object)newState);
                this.plugin.saveConfig();
                this.plugin.getConfigManager().setDebugLog(newState);
                this.plugin.getLangManager().sendMessage(sender, "messages.debugLog", text -> text.replace("<state>", newState ? "on" : "off"));
                break;
            }
            case "extras": {
                boolean newState = !this.plugin.getConfigManager().isDebugExtras();
                this.plugin.getConfig().set("debugs.extras", (Object)newState);
                this.plugin.saveConfig();
                this.plugin.getConfigManager().setDebugExtras(newState);
                this.plugin.getLangManager().sendMessage(sender, "messages.debugExtras", text -> text.replace("<state>", newState ? "on" : "off"));
                break;
            }
            default: {
                sender.sendMessage("Invalid debug type.");
            }
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new ArrayList<String>(Arrays.asList("save", "log", "extras"));
    }
}

