/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventorySerializable {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String itemStackToBase64(ItemStack item) {
        if (item == null) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeObject((Object)item);
                string = Base64Coder.encodeLines((byte[])outputStream.toByteArray());
            }
            return string;
        }
        catch (Exception e) {
            return InventorySerializable.itemStackToBase64Fallback(item);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack itemStackFromBase64(String data) {
        if (data == null || data.trim().isEmpty() || data.equals("null")) {
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));){
            ItemStack itemStack;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                itemStack = (ItemStack)dataInput.readObject();
            }
            return itemStack;
        }
        catch (ClassNotFoundException e) {
            return InventorySerializable.itemStackFromBase64Fallback(data);
        }
    }

    public static String itemStackToBase64Fallback(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("item", (Object)item);
            String yaml = config.saveToString();
            return Base64.getEncoder().encodeToString(yaml.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public static ItemStack itemStackFromBase64Fallback(String data) {
        if (data == null || data.trim().isEmpty() || data.equals("null")) {
            return null;
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(data);
            String yaml = new String(decodedBytes, StandardCharsets.UTF_8);
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(yaml);
            Object item = config.get("item");
            if (item instanceof ItemStack) {
                return (ItemStack)item;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

