/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.listeners;

import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.xseries.XEntityType;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplodeListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExplode(BlockExplodeEvent event) {
        long playerId = PlayerUtils.getPlayerOrEntityId("=explosion");
        event.blockList().forEach(block -> {
            if (ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), block.getType().name())) {
                return;
            }
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, (Block)block, ActionType.BLOCK_BREAK));
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntity(EntityExplodeEvent event) {
        EntityType entityType = event.getEntityType();
        long playerId = entityType == EntityType.CREEPER ? PlayerUtils.getEntityByDirectId("=creeper") : (entityType == EntityType.WITHER ? PlayerUtils.getEntityByDirectId("=wither") : (entityType == EntityType.WITHER_SKULL ? PlayerUtils.getEntityByDirectId("=wither") : (entityType == EntityType.FIREBALL ? PlayerUtils.getEntityByDirectId("=ghast") : (entityType.name().equals("MINECART_TNT") ? PlayerUtils.getEntityByDirectId("=tnt") : (entityType == XEntityType.TNT.get() ? PlayerUtils.getEntityByDirectId("=tnt") : (entityType == XEntityType.END_CRYSTAL.get() ? PlayerUtils.getEntityByDirectId("=end_crystal") : PlayerUtils.getPlayerOrEntityId("=explosion")))))));
        event.blockList().forEach(block -> {
            if (ActionType.BLOCK_BREAK.shouldSkipLog(block.getWorld().getName(), block.getType().name())) {
                return;
            }
            LoggerCache.addLog(new PlayerBlockLogEntry(playerId, (Block)block, ActionType.BLOCK_BREAK));
        });
    }
}

