/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.types.sql;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.database.repositories.ItemsRepository;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.utils.Debugger;
import io.github.insideranh.stellarprotect.utils.InventorySerializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bukkit.inventory.ItemStack;

public class ItemsRepositorySQL
implements ItemsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public ItemsRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void saveItems(List<ItemTemplate> itemTemplates) {
        this.stellarProtect.getExecutor().execute(() -> {
            String sql = "INSERT OR REPLACE INTO " + this.stellarProtect.getConfigManager().getTablesItemTemplates() + " (id, base64, s) VALUES (?, ?, ?)";
            try (PreparedStatement statement = this.connection.prepareStatement(sql);){
                this.connection.setAutoCommit(false);
                int batchSize = 0;
                int maxBatchSize = 1000;
                statement.setByte(3, (byte)0);
                for (ItemTemplate template : itemTemplates) {
                    if (template == null) continue;
                    statement.setLong(1, template.getId());
                    statement.setString(2, template.getBase64());
                    statement.addBatch();
                    if (++batchSize < maxBatchSize) continue;
                    statement.executeBatch();
                    this.connection.commit();
                    statement.clearBatch();
                    batchSize = 0;
                }
                if (batchSize > 0) {
                    statement.executeBatch();
                }
                this.connection.commit();
                Debugger.debugSave("Saved " + itemTemplates.size() + " item templates in SQLite");
            }
            catch (SQLException e) {
                Debugger.debugSave("Error on save items in SQLite: " + e.getMessage());
            }
        });
    }

    @Override
    public void loadMostUsedItems() {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            String sql = "SELECT id, base64, s, access_count, last_accessed, total_quantity_used, created_at FROM " + this.stellarProtect.getConfigManager().getTablesItemTemplates() + " ORDER BY access_count DESC, total_quantity_used DESC";
            try (PreparedStatement statement = this.connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    long id = resultSet.getLong("id");
                    String base64 = resultSet.getString("base64");
                    ItemStack bukkitItem = InventorySerializable.itemStackFromBase64(base64);
                    ItemTemplate template = new ItemTemplate(id, bukkitItem, base64);
                    this.stellarProtect.getItemsManager().loadItemReference(template, base64);
                }
                long count = this.stellarProtect.getItemsManager().getItemReferenceCount();
                this.stellarProtect.getItemsManager().getCurrentId().set(count + 1L);
                Debugger.debugLog("Loaded " + count + " item references.");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().info("Error en loadMostUsedItems: " + e.getMessage());
            }
        });
        executor.shutdown();
    }
}

