/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import java.sql.ResultSet;
import java.util.Arrays;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerSignChangeEntry
extends LogEntry {
    private final String[] lines;

    public PlayerSignChangeEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.lines = jsonObject.get("l").getAsString().split("\n");
    }

    public PlayerSignChangeEntry(long playerId, Location location, String[] lines, ActionType actionType) {
        super(playerId, actionType.getId(), location, System.currentTimeMillis());
        this.lines = lines;
    }

    public String getLine(int index) {
        if (this.lines.length > index) {
            return this.lines[index];
        }
        return "";
    }

    @Override
    public String getDataString() {
        return Arrays.toString(this.lines);
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerSignChangeEntry entry = this;
        obj.addProperty("l", String.join((CharSequence)"\n", entry.getLines()));
        return obj.toString();
    }

    @Generated
    public String[] getLines() {
        return this.lines;
    }
}

