/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.data;

import io.github.insideranh.stellarprotect.data.InspectSession;
import io.github.insideranh.stellarprotect.data.InventoryRollbackSession;
import io.github.insideranh.stellarprotect.data.LookupSession;
import io.github.insideranh.stellarprotect.data.RestoreSession;
import io.github.insideranh.stellarprotect.data.UndoSession;
import io.github.insideranh.stellarprotect.maps.ObjectLongMap;
import io.github.insideranh.stellarprotect.maps.ObjectObjectMap;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerProtect {
    private static final ObjectObjectMap<UUID, PlayerProtect> players = new ObjectObjectMap(120);
    private static final ObjectLongMap<String> nameToIdCache = new ObjectLongMap(120);
    private final long playerId;
    private final UUID uuid;
    private final String name;
    private final String realName;
    private LookupSession lookupSession;
    private InspectSession inspectSession;
    private RestoreSession restoreSession;
    private UndoSession undoSession;
    private InventoryRollbackSession inventoryRollbackSession;
    private boolean inspect;
    private long nextLookup;
    private long nextUse;
    private long nextInspect;
    private long loginTime;
    private double lastEconomyBalance;
    private Location lastLocation;
    private int lastPickUpAmount;
    private long pickUpXYZ;
    private long lastPickItemId;
    private long nextSeparateLogPickUp;
    private HashMap<Integer, Object> posibleLogs = new HashMap();

    public PlayerProtect(UUID uuid, String name, long playerId) {
        this.playerId = playerId;
        this.name = name.toLowerCase();
        this.realName = name;
        this.uuid = uuid;
    }

    public static PlayerProtect getPlayer(Player player) {
        return players.get(player.getUniqueId());
    }

    public static PlayerProtect removePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        PlayerProtect removed = players.remove(uuid);
        if (removed != null) {
            nameToIdCache.removeLong(removed.name);
        }
        return removed;
    }

    public static long getPlayerId(String name) {
        String lowerName = name.toLowerCase();
        if (nameToIdCache.containsKey(lowerName)) {
            return nameToIdCache.getLong(lowerName);
        }
        for (PlayerProtect playerProtect : players.values()) {
            if (!playerProtect.name.equals(lowerName)) continue;
            nameToIdCache.put(lowerName, playerProtect.playerId);
            return playerProtect.playerId;
        }
        return -2L;
    }

    public void create() {
        players.put(this.uuid, this);
        nameToIdCache.put(this.name, this.playerId);
    }

    @Generated
    public long getPlayerId() {
        return this.playerId;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRealName() {
        return this.realName;
    }

    @Generated
    public LookupSession getLookupSession() {
        return this.lookupSession;
    }

    @Generated
    public InspectSession getInspectSession() {
        return this.inspectSession;
    }

    @Generated
    public RestoreSession getRestoreSession() {
        return this.restoreSession;
    }

    @Generated
    public UndoSession getUndoSession() {
        return this.undoSession;
    }

    @Generated
    public InventoryRollbackSession getInventoryRollbackSession() {
        return this.inventoryRollbackSession;
    }

    @Generated
    public boolean isInspect() {
        return this.inspect;
    }

    @Generated
    public long getNextLookup() {
        return this.nextLookup;
    }

    @Generated
    public long getNextUse() {
        return this.nextUse;
    }

    @Generated
    public long getNextInspect() {
        return this.nextInspect;
    }

    @Generated
    public long getLoginTime() {
        return this.loginTime;
    }

    @Generated
    public double getLastEconomyBalance() {
        return this.lastEconomyBalance;
    }

    @Generated
    public Location getLastLocation() {
        return this.lastLocation;
    }

    @Generated
    public int getLastPickUpAmount() {
        return this.lastPickUpAmount;
    }

    @Generated
    public long getPickUpXYZ() {
        return this.pickUpXYZ;
    }

    @Generated
    public long getLastPickItemId() {
        return this.lastPickItemId;
    }

    @Generated
    public long getNextSeparateLogPickUp() {
        return this.nextSeparateLogPickUp;
    }

    @Generated
    public HashMap<Integer, Object> getPosibleLogs() {
        return this.posibleLogs;
    }

    @Generated
    public void setLookupSession(LookupSession lookupSession) {
        this.lookupSession = lookupSession;
    }

    @Generated
    public void setInspectSession(InspectSession inspectSession) {
        this.inspectSession = inspectSession;
    }

    @Generated
    public void setRestoreSession(RestoreSession restoreSession) {
        this.restoreSession = restoreSession;
    }

    @Generated
    public void setUndoSession(UndoSession undoSession) {
        this.undoSession = undoSession;
    }

    @Generated
    public void setInventoryRollbackSession(InventoryRollbackSession inventoryRollbackSession) {
        this.inventoryRollbackSession = inventoryRollbackSession;
    }

    @Generated
    public void setInspect(boolean inspect) {
        this.inspect = inspect;
    }

    @Generated
    public void setNextLookup(long nextLookup) {
        this.nextLookup = nextLookup;
    }

    @Generated
    public void setNextUse(long nextUse) {
        this.nextUse = nextUse;
    }

    @Generated
    public void setNextInspect(long nextInspect) {
        this.nextInspect = nextInspect;
    }

    @Generated
    public void setLoginTime(long loginTime) {
        this.loginTime = loginTime;
    }

    @Generated
    public void setLastEconomyBalance(double lastEconomyBalance) {
        this.lastEconomyBalance = lastEconomyBalance;
    }

    @Generated
    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation;
    }

    @Generated
    public void setLastPickUpAmount(int lastPickUpAmount) {
        this.lastPickUpAmount = lastPickUpAmount;
    }

    @Generated
    public void setPickUpXYZ(long pickUpXYZ) {
        this.pickUpXYZ = pickUpXYZ;
    }

    @Generated
    public void setLastPickItemId(long lastPickItemId) {
        this.lastPickItemId = lastPickItemId;
    }

    @Generated
    public void setNextSeparateLogPickUp(long nextSeparateLogPickUp) {
        this.nextSeparateLogPickUp = nextSeparateLogPickUp;
    }

    @Generated
    public void setPosibleLogs(HashMap<Integer, Object> posibleLogs) {
        this.posibleLogs = posibleLogs;
    }
}

