/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments.basic;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.LoggerCache;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.items.MemoryAnalysisItem;
import io.github.insideranh.stellarprotect.items.memory.ItemTemplateLight;
import io.github.insideranh.stellarprotect.libs.jol.info.GraphLayout;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class MemoryArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        boolean footprint = arguments.length > 0 && arguments[0].equalsIgnoreCase("footprint");
        sender.sendMessage("\u00a7aLoading memory analysis...");
        this.plugin.getLookupExecutor().execute(() -> {
            LinkedHashMap<String, MemoryAnalysisItem> memoryObjects = new LinkedHashMap<String, MemoryAnalysisItem>();
            HashMap<Long, ItemTemplateLight> idToTemplate = new HashMap<Long, ItemTemplateLight>();
            for (ItemTemplate item : this.plugin.getItemsManager().getItemCache().items()) {
                if (item == null) continue;
                ItemTemplateLight light = new ItemTemplateLight(item.getId(), item.getBase64(), item.getDisplayName(), item.getLore(), item.getTypeName(), item.getDisplayNameLower(), item.getLoreLower(), item.getTypeNameLower());
                idToTemplate.put(item.getId(), light);
            }
            memoryObjects.put("messages.memory.itemTemplates", new MemoryAnalysisItem(idToTemplate));
            memoryObjects.put("messages.memory.cachedLogsByCategory", new MemoryAnalysisItem(LoggerCache.getCachedLogsByCategory()));
            memoryObjects.put("messages.memory.unSavedLogsByCategory", new MemoryAnalysisItem(LoggerCache.getUnSavedLogsByCategory()));
            memoryObjects.put("messages.memory.placedBlockLogs", new MemoryAnalysisItem(LoggerCache.getPlacedBlockLogs()));
            memoryObjects.put("messages.memory.queryCache", new MemoryAnalysisItem(LoggerCache.getQueryCache()));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.title"));
            long totalMemoryUsage = 0L;
            for (Map.Entry entry : memoryObjects.entrySet()) {
                String messageKey = (String)entry.getKey();
                MemoryAnalysisItem item = (MemoryAnalysisItem)entry.getValue();
                sender.sendMessage(this.plugin.getLangManager().get(messageKey));
                GraphLayout layout = GraphLayout.parseInstance(item.getObject());
                if (footprint) {
                    sender.sendMessage(this.plugin.getLangManager().get("messages.memory.footprint"));
                    sender.sendMessage(layout.toFootprint());
                }
                long sizeInBytes = layout.totalSize();
                String formattedSize = this.formatMemorySize(sizeInBytes);
                sender.sendMessage(this.plugin.getLangManager().get("messages.memory.total") + " " + formattedSize);
                sender.sendMessage("");
                totalMemoryUsage += sizeInBytes;
            }
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.title"));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.totalMemory") + this.formatMemorySize(totalMemoryUsage));
            sender.sendMessage(this.plugin.getLangManager().get("messages.memory.summary.objectsAnalyzed") + memoryObjects.size());
        });
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new LinkedList<String>(Collections.singletonList("footprint"));
    }

    private String formatMemorySize(long bytes) {
        if (bytes < 1024L) {
            return "\u00a7f" + bytes + " \u00a77bytes";
        }
        double kb = (double)bytes / 1024.0;
        if (kb < 1024.0) {
            return String.format("\u00a7f%.2f \u00a77KB \u00a78(\u00a7f%d \u00a77bytes\u00a78)", kb, bytes);
        }
        double mb = kb / 1024.0;
        if (mb < 1024.0) {
            return String.format("\u00a7f%.2f \u00a77MB \u00a78(\u00a7f%.2f \u00a77KB\u00a78)", mb, kb);
        }
        double gb = mb / 1024.0;
        return String.format("\u00a7f%.2f \u00a77GB \u00a78(\u00a7f%.2f \u00a77MB\u00a78)", gb, mb);
    }
}

