/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.cache;

import io.github.insideranh.stellarprotect.blocks.BlockTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlocksCache {
    private static final int CAPACITY = 4096;
    private static final int MASK = 4095;
    private static final float LOAD_FACTOR = 0.7f;
    private final BlockTemplate[] items = new BlockTemplate[4096];
    private final IndexEntry[] idIndex = new IndexEntry[4096];
    private final IndexEntry[] typeNameIndex = new IndexEntry[4096];
    private final Map<String, IntOpenHashSet> typeNameTokens = new HashMap<String, IntOpenHashSet>();
    private final int[] validPositions = new int[4096];
    private int validCount = 0;
    private int size = 0;

    private static long hash(String str) {
        int i;
        if (str == null) {
            return 0L;
        }
        long hash = 0L;
        int len = str.length();
        for (i = 0; i < len - 3; i += 4) {
            hash = (hash << 5) - hash + (long)str.charAt(i);
            hash = (hash << 5) - hash + (long)str.charAt(i + 1);
            hash = (hash << 5) - hash + (long)str.charAt(i + 2);
            hash = (hash << 5) - hash + (long)str.charAt(i + 3);
        }
        while (i < len) {
            hash = (hash << 5) - hash + (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    private static long hashLong(long value) {
        value = (value ^ 0xFFFFFFFFFFFFFFFFL) + (value << 18);
        value ^= value >>> 31;
        value *= 21L;
        value ^= value >>> 11;
        value += value << 6;
        value ^= value >>> 22;
        return value;
    }

    private void indexSubstrings(String text, Map<String, IntOpenHashSet> tokenMap, int position) {
        String[] words;
        if (text == null || text.isEmpty()) {
            return;
        }
        String lowerText = text.toLowerCase();
        for (int len = 2; len <= Math.min(6, lowerText.length()); ++len) {
            for (int i = 0; i <= lowerText.length() - len; ++i) {
                String substring = lowerText.substring(i, i + len);
                tokenMap.computeIfAbsent(substring, k -> new IntOpenHashSet()).add(position);
            }
        }
        for (String word : words = lowerText.split("\\s+")) {
            if (word.isEmpty()) continue;
            tokenMap.computeIfAbsent(word, k -> new IntOpenHashSet()).add(position);
        }
    }

    private int findFreePosition() {
        for (int i = 0; i < 4096; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        throw new IllegalStateException("Cache full");
    }

    private void addToStringIndex(IndexEntry[] index, String key, int position) {
        if (key == null) {
            return;
        }
        long hash = BlocksCache.hash(key);
        int slot = (int)(hash & 0xFFFL);
        IndexEntry entry = new IndexEntry(hash, position);
        while (index[slot] != null) {
            if (index[slot].hash == hash) {
                entry.next = index[slot].next;
                index[slot] = entry;
                return;
            }
            slot = slot + 1 & 0xFFF;
        }
        index[slot] = entry;
    }

    private void addToIdIndex(long id, int position) {
        long hash = BlocksCache.hashLong(id);
        int slot = (int)(hash & 0xFFFL);
        IndexEntry entry = new IndexEntry(hash, position);
        while (this.idIndex[slot] != null) {
            if (this.idIndex[slot].hash == hash) {
                entry.next = this.idIndex[slot].next;
                this.idIndex[slot] = entry;
                return;
            }
            slot = slot + 1 & 0xFFF;
        }
        this.idIndex[slot] = entry;
    }

    private BlockTemplate searchInStringIndex(IndexEntry[] index, String key) {
        if (key == null) {
            return null;
        }
        long hash = BlocksCache.hash(key);
        int slot = (int)(hash & 0xFFFL);
        while (index[slot] != null) {
            BlockTemplate item;
            IndexEntry entry = index[slot];
            if (entry.hash == hash && (item = this.items[entry.position]) != null && index == this.typeNameIndex && key.equals(item.getTypeName())) {
                return item;
            }
            slot = slot + 1 & 0xFFF;
        }
        return null;
    }

    private BlockTemplate searchById(long id) {
        long hash = BlocksCache.hashLong(id);
        int slot = (int)(hash & 0xFFFL);
        while (this.idIndex[slot] != null) {
            BlockTemplate item;
            IndexEntry entry = this.idIndex[slot];
            if (entry.hash == hash && (item = this.items[entry.position]) != null && (long)item.getId() == id) {
                return item;
            }
            slot = slot + 1 & 0xFFF;
        }
        return null;
    }

    private List<Long> findContains(String searchText, Map<String, IntOpenHashSet> tokenMap, FieldType fieldType) {
        if (searchText == null || searchText.isEmpty()) {
            return new ArrayList<Long>();
        }
        String lowerSearch = searchText.toLowerCase();
        ArrayList<Long> results = new ArrayList<Long>();
        IntOpenHashSet candidatePositions = tokenMap.get(lowerSearch);
        if (candidatePositions != null) {
            int[] positions;
            for (int pos : positions = candidatePositions.toArray()) {
                BlockTemplate item = this.items[pos];
                if (item == null) continue;
                results.add(Long.valueOf(item.getId()));
            }
            return results;
        }
        String bestMatch = null;
        IntOpenHashSet bestPositions = null;
        for (int len = Math.min(lowerSearch.length(), 6); len >= 2; --len) {
            for (int i = 0; i <= lowerSearch.length() - len; ++i) {
                String candidate = lowerSearch.substring(i, i + len);
                IntOpenHashSet positions = tokenMap.get(candidate);
                if (positions == null) continue;
                bestMatch = candidate;
                bestPositions = positions;
                break;
            }
            if (bestMatch != null) break;
        }
        if (bestPositions != null) {
            int[] positions;
            for (int pos : positions = bestPositions.toArray()) {
                String fieldValue;
                BlockTemplate item = this.items[pos];
                if (item == null || (fieldValue = this.getFieldValue(item, fieldType)) == null || !fieldValue.contains(lowerSearch)) continue;
                results.add(Long.valueOf(item.getId()));
            }
            return results;
        }
        for (int i = 0; i < this.validCount; ++i) {
            String fieldValue;
            int pos = this.validPositions[i];
            BlockTemplate item = this.items[pos];
            if (item == null || (fieldValue = this.getFieldValue(item, fieldType)) == null || !fieldValue.contains(lowerSearch)) continue;
            results.add(Long.valueOf(item.getId()));
        }
        return results;
    }

    private String getFieldValue(BlockTemplate item, FieldType fieldType) {
        switch (fieldType.ordinal()) {
            case 0: {
                return item.getTypeName();
            }
            case 1: {
                return item.getTypeNameLower();
            }
        }
        return null;
    }

    public boolean put(BlockTemplate block) {
        if ((float)this.size >= 2867.2f) {
            return false;
        }
        int position = this.findFreePosition();
        this.items[position] = block;
        this.validPositions[this.validCount++] = position;
        this.addToIdIndex(block.getId(), position);
        if (block.getTypeName() != null) {
            this.addToStringIndex(this.typeNameIndex, block.getTypeName(), position);
        }
        if (block.getTypeName() != null) {
            this.indexSubstrings(block.getTypeName(), this.typeNameTokens, position);
        }
        ++this.size;
        return true;
    }

    public BlockTemplate getById(long id) {
        return this.searchById(id);
    }

    public BlockTemplate getByTypeNameExact(String typeName) {
        return this.searchInStringIndex(this.typeNameIndex, typeName);
    }

    public List<Long> findIdsByTypeNameContains(List<String> searchTexts, FieldType fieldType) {
        if (searchTexts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (String searchText : searchTexts) {
            result.addAll(this.findContains(searchText, this.typeNameTokens, fieldType));
        }
        return result;
    }

    public List<Long> findIdsContains(Map<String, List<String>> searchTexts) {
        if (searchTexts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        if (searchTexts.containsKey("material_type")) {
            result.addAll(this.findIdsByTypeNameContains(searchTexts.get("material_type"), FieldType.LOWER_TYPE_NAME));
        }
        return result;
    }

    public BlockTemplate[] items() {
        return this.items;
    }

    public int size() {
        return this.size;
    }

    private static class IndexEntry {
        final long hash;
        final int position;
        IndexEntry next;

        IndexEntry(long hash, int position) {
            this.hash = hash;
            this.position = position;
        }
    }

    private static class IntOpenHashSet {
        private int[] keys;
        private boolean[] allocated;
        private int size;

        public IntOpenHashSet() {
            this(16);
        }

        public IntOpenHashSet(int capacity) {
            capacity = IntOpenHashSet.nextPowerOfTwo(capacity);
            this.keys = new int[capacity];
            this.allocated = new boolean[capacity];
            this.size = 0;
        }

        private static int nextPowerOfTwo(int n) {
            --n;
            n |= n >> 1;
            n |= n >> 2;
            n |= n >> 4;
            n |= n >> 8;
            n |= n >> 16;
            return n + 1;
        }

        public void add(int key) {
            float loadFactor = 0.75f;
            if ((float)this.size >= (float)this.keys.length * loadFactor) {
                this.resize();
            }
            int slot = key & this.keys.length - 1;
            while (this.allocated[slot]) {
                if (this.keys[slot] == key) {
                    return;
                }
                slot = slot + 1 & this.keys.length - 1;
            }
            this.keys[slot] = key;
            this.allocated[slot] = true;
            ++this.size;
        }

        public int[] toArray() {
            int[] result = new int[this.size];
            int idx = 0;
            for (int i = 0; i < this.allocated.length; ++i) {
                if (!this.allocated[i]) continue;
                result[idx++] = this.keys[i];
            }
            return result;
        }

        private void resize() {
            int[] oldKeys = this.keys;
            boolean[] oldAllocated = this.allocated;
            this.keys = new int[oldKeys.length * 2];
            this.allocated = new boolean[oldAllocated.length * 2];
            this.size = 0;
            for (int i = 0; i < oldAllocated.length; ++i) {
                if (!oldAllocated[i]) continue;
                this.add(oldKeys[i]);
            }
        }
    }

    public static enum FieldType {
        TYPE_NAME,
        LOWER_TYPE_NAME;

    }
}

