/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.config.PatternConfig;
import io.github.insideranh.stellarprotect.config.WorldConfigType;
import io.github.insideranh.stellarprotect.config.suspicious.TpaSuspiciousConfig;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.enums.SuspiciousType;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final HashMap<SuspiciousType, PatternConfig> patternConfigs = new HashMap();
    private boolean debugLog;
    private boolean debugSave;
    private boolean debugExtras;
    private boolean liquidTracking;
    private int maxCores;
    private int batchSize;
    private int savePeriod;
    private int maxLogsPerLocation;
    private int deleteOldPeriod;
    private long timeForCacheClear;
    private long cleanPlacedCachePeriod;
    private int daysToKeepLogs;
    private int saveItemPeriod;
    private int saveBlockPeriod;
    private boolean suspiciousPatterns;
    private boolean checkUpdates;
    private boolean economyDisabled;
    private int economyCheckInterval;
    private String tablesPrefix;
    private String tablesPlayers;
    private String tablesLogEntries;
    private String tablesIdCounter;
    private String tablesItemTemplates;
    private String tablesBlockTemplates;
    private String tablesWorlds;
    private String tablesEntityIds;
    private String itemsLang;

    public void load() {
        this.checkUpdates = this.plugin.getConfig().getBoolean("check-updates");
        this.debugLog = this.plugin.getConfig().getBoolean("debugs.log");
        this.debugSave = this.plugin.getConfig().getBoolean("debugs.save");
        this.debugExtras = this.plugin.getConfig().getBoolean("debugs.extras");
        this.liquidTracking = this.plugin.getConfig().getBoolean("advanced.liquid-tracking");
        this.suspiciousPatterns = this.plugin.getConfig().getBoolean("features.suspicious-patterns.enabled");
        this.itemsLang = this.plugin.getConfig().getString("features.translations.items_lang");
        this.patternConfigs.put(SuspiciousType.TPA_KILL, new TpaSuspiciousConfig(this.plugin.getConfig(), "features.suspicious-patterns.suspicious-tpa-kill"));
        this.maxCores = Math.max(this.plugin.getConfig().getInt("optimizations.maxCores"), 4);
        this.savePeriod = this.plugin.getConfig().getInt("optimizations.save-period");
        this.batchSize = this.plugin.getConfig().getInt("optimizations.batch-size");
        this.maxLogsPerLocation = this.plugin.getConfig().getInt("optimizations.max-logs-per-location");
        this.timeForCacheClear = this.plugin.getConfig().getLong("optimizations.time-for-cache-clear") * 60L * 1000L;
        this.daysToKeepLogs = this.plugin.getConfig().getInt("optimizations.days-to-keep-logs");
        this.deleteOldPeriod = this.plugin.getConfig().getInt("optimizations.delete-old-period") * 60;
        this.cleanPlacedCachePeriod = this.plugin.getConfig().getLong("optimizations.clean-placed-cache-period") * 1000L;
        this.saveItemPeriod = this.plugin.getConfig().getInt("optimizations.item-save-period");
        this.saveBlockPeriod = this.plugin.getConfig().getInt("optimizations.block-save-period");
        this.economyDisabled = this.plugin.getConfig().getBoolean("optimizations.economy-disabled");
        this.economyCheckInterval = this.plugin.getConfig().getInt("optimizations.economy-check-interval");
        this.tablesPrefix = this.plugin.getConfig().getString("tablesOrCollections.prefix", "");
        this.tablesPlayers = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.players", "players");
        this.tablesLogEntries = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.log_entries", "log_entries");
        this.tablesIdCounter = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.id_counter", "id_counter");
        this.tablesItemTemplates = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.item_templates", "item_templates");
        this.tablesBlockTemplates = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.block_templates", "block_templates");
        this.tablesWorlds = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.worlds", "worlds");
        this.tablesEntityIds = this.tablesPrefix + this.plugin.getConfig().getString("tablesOrCollections.entity_ids", "entity_ids");
        HashMap worlds = new HashMap();
        File worldsFolder = new File(this.plugin.getDataFolder(), "worlds");
        if (!worldsFolder.exists()) {
            worldsFolder.mkdirs();
        }
        for (File file : Objects.requireNonNull(worldsFolder.listFiles())) {
            if (!file.isFile()) continue;
            String world = file.getName().replace(".yml", "");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            if (!config.isConfigurationSection("logs") || !config.getBoolean("enabled")) continue;
            for (ActionType actionType : ActionType.values()) {
                if (!config.isConfigurationSection("logs." + actionType.name().toLowerCase())) continue;
                WorldConfigType worldConfigType = new WorldConfigType();
                List disableTypes = config.getStringList("logs." + actionType.name().toLowerCase() + ".disable_types").stream().map(String::toLowerCase).collect(Collectors.toList());
                if (disableTypes.contains("all")) {
                    worldConfigType.setDisableAll(true);
                }
                boolean isEmptyOrNone = disableTypes.isEmpty() || disableTypes.size() == 1 && disableTypes.contains("none");
                worldConfigType.setEnabled(config.getBoolean("logs." + actionType.name().toLowerCase() + ".enabled"));
                worldConfigType.setHasNoDisabledTypes(isEmptyOrNone);
                worldConfigType.getDisabledTypes().addAll(disableTypes);
                worlds.computeIfAbsent(actionType, k -> new HashMap()).put(world, worldConfigType);
            }
        }
        for (ActionType actionType : ActionType.values()) {
            HashMap worldsConfig = worlds.getOrDefault((Object)actionType, new HashMap());
            actionType.getWorldTypes().putAll(worldsConfig);
            boolean enabled = this.plugin.getConfig().getBoolean("logs." + actionType.name().toLowerCase() + ".enabled");
            List worldList = this.plugin.getConfig().getStringList("logs." + actionType.name().toLowerCase() + ".worlds").stream().map(String::toLowerCase).collect(Collectors.toList());
            List disableTypesList = this.plugin.getConfig().getStringList("logs." + actionType.name().toLowerCase() + ".disable_types").stream().map(String::toLowerCase).collect(Collectors.toList());
            if (disableTypesList.contains("all")) {
                actionType.setHasDisableAll(true);
            }
            boolean isEmptyOrNone = disableTypesList.isEmpty() || disableTypesList.size() == 1 && disableTypesList.contains("none");
            actionType.setEnabled(enabled);
            actionType.setHasNoDisabledTypes(isEmptyOrNone);
            actionType.setHasAllWorlds(worldList.contains("all"));
            actionType.getWorlds().addAll(worldList);
            actionType.getDisabledTypes().addAll(disableTypesList);
        }
    }

    public PatternConfig getPatternConfig(SuspiciousType suspiciousType) {
        return this.patternConfigs.get((Object)suspiciousType);
    }

    @Generated
    public StellarProtect getPlugin() {
        return this.plugin;
    }

    @Generated
    public HashMap<SuspiciousType, PatternConfig> getPatternConfigs() {
        return this.patternConfigs;
    }

    @Generated
    public boolean isDebugLog() {
        return this.debugLog;
    }

    @Generated
    public boolean isDebugSave() {
        return this.debugSave;
    }

    @Generated
    public boolean isDebugExtras() {
        return this.debugExtras;
    }

    @Generated
    public boolean isLiquidTracking() {
        return this.liquidTracking;
    }

    @Generated
    public int getMaxCores() {
        return this.maxCores;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public int getSavePeriod() {
        return this.savePeriod;
    }

    @Generated
    public int getMaxLogsPerLocation() {
        return this.maxLogsPerLocation;
    }

    @Generated
    public int getDeleteOldPeriod() {
        return this.deleteOldPeriod;
    }

    @Generated
    public long getTimeForCacheClear() {
        return this.timeForCacheClear;
    }

    @Generated
    public long getCleanPlacedCachePeriod() {
        return this.cleanPlacedCachePeriod;
    }

    @Generated
    public int getDaysToKeepLogs() {
        return this.daysToKeepLogs;
    }

    @Generated
    public int getSaveItemPeriod() {
        return this.saveItemPeriod;
    }

    @Generated
    public int getSaveBlockPeriod() {
        return this.saveBlockPeriod;
    }

    @Generated
    public boolean isSuspiciousPatterns() {
        return this.suspiciousPatterns;
    }

    @Generated
    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }

    @Generated
    public boolean isEconomyDisabled() {
        return this.economyDisabled;
    }

    @Generated
    public int getEconomyCheckInterval() {
        return this.economyCheckInterval;
    }

    @Generated
    public String getTablesPrefix() {
        return this.tablesPrefix;
    }

    @Generated
    public String getTablesPlayers() {
        return this.tablesPlayers;
    }

    @Generated
    public String getTablesLogEntries() {
        return this.tablesLogEntries;
    }

    @Generated
    public String getTablesIdCounter() {
        return this.tablesIdCounter;
    }

    @Generated
    public String getTablesItemTemplates() {
        return this.tablesItemTemplates;
    }

    @Generated
    public String getTablesBlockTemplates() {
        return this.tablesBlockTemplates;
    }

    @Generated
    public String getTablesWorlds() {
        return this.tablesWorlds;
    }

    @Generated
    public String getTablesEntityIds() {
        return this.tablesEntityIds;
    }

    @Generated
    public String getItemsLang() {
        return this.itemsLang;
    }

    @Generated
    public void setDebugLog(boolean debugLog) {
        this.debugLog = debugLog;
    }

    @Generated
    public void setDebugSave(boolean debugSave) {
        this.debugSave = debugSave;
    }

    @Generated
    public void setDebugExtras(boolean debugExtras) {
        this.debugExtras = debugExtras;
    }
}

