/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.inspect;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerItemLogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.inspect.InspectHandler;
import io.github.insideranh.stellarprotect.items.ItemTemplate;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.StringCleanerUtils;
import io.github.insideranh.stellarprotect.utils.TimeUtils;
import io.github.insideranh.stellarprotect.utils.TooltipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemLogActionHandler
implements InspectHandler.ActionHandler {
    private static boolean hasDisplayName(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().hasDisplayName();
    }

    private static boolean hasLore(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().hasLore();
    }

    private static boolean hasEnchants(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().hasEnchants();
    }

    @Override
    public void handle(Player player, LogEntry logEntry, StellarProtect plugin) {
        PlayerItemLogEntry itemLogEntry = (PlayerItemLogEntry)logEntry;
        ActionType actionType = ActionType.getById(itemLogEntry.getActionType());
        if (actionType == null) {
            return;
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        ItemDetails itemDetails = this.buildItemDetails(itemLogEntry, plugin);
        if (itemDetails == null) {
            return;
        }
        String tooltipBody = this.buildTooltipBody(itemDetails, plugin);
        playerProtect.getPosibleLogs().put(itemLogEntry.hashCode(), itemLogEntry);
        this.sendActionTitle(player, itemDetails, tooltipBody, logEntry, actionType, plugin);
    }

    private ItemDetails buildItemDetails(PlayerItemLogEntry itemLogEntry, StellarProtect plugin) {
        ItemTemplate itemTemplate = plugin.getItemsManager().getItemTemplate(itemLogEntry.getItemReferenceId());
        if (itemTemplate == null) {
            return null;
        }
        ItemStack item = itemTemplate.getBukkitItem();
        String cleanName = StringCleanerUtils.parseMinecraftData(item.getType().name()).getCleanName();
        return new ItemDetails(item, itemLogEntry.getAmount(), cleanName);
    }

    private String buildTooltipBody(ItemDetails itemDetails, StellarProtect plugin) {
        ArrayList<String> bodyLines = new ArrayList<String>();
        List<String> templateLines = plugin.getLangManager().getList("messages.tooltips.item_details.body");
        for (String line : templateLines) {
            bodyLines.addAll(this.processTemplateLine(line, itemDetails, plugin));
        }
        return String.join((CharSequence)"\n", bodyLines);
    }

    private List<String> processTemplateLine(String line, ItemDetails itemDetails, StellarProtect plugin) {
        ItemStack item = itemDetails.getItem();
        if (line.contains("<display_name>")) {
            if (ItemLogActionHandler.hasDisplayName(item)) {
                return this.replaceTemplate("displayName", item.getItemMeta().getDisplayName(), plugin);
            }
            return new LinkedList<String>();
        }
        if (line.contains("<lore>")) {
            if (ItemLogActionHandler.hasLore(item)) {
                String joinedLore = String.join((CharSequence)"\n", item.getItemMeta().getLore());
                return this.replaceTemplate("lore", joinedLore, plugin);
            }
            return new LinkedList<String>();
        }
        if (line.contains("<enchants>")) {
            if (ItemLogActionHandler.hasEnchants(item)) {
                return this.replaceTemplate("enchants", TooltipUtils.getTooltipEnchants(item), plugin);
            }
            return new LinkedList<String>();
        }
        return new LinkedList<String>(Collections.singletonList(line.replace("<amount>", String.valueOf(itemDetails.getAmount()))));
    }

    private List<String> replaceTemplate(String templateType, String value, StellarProtect plugin) {
        String langKey = "messages.tooltips.item_details." + templateType;
        String placeholder = "<" + templateType + ">";
        return plugin.getLangManager().getList(langKey).stream().map(template -> template.replace(placeholder, value)).collect(Collectors.toList());
    }

    private void sendActionTitle(Player player, ItemDetails itemDetails, String tooltipBody, LogEntry logEntry, ActionType actionType, StellarProtect plugin) {
        String actionKey = actionType.name().toLowerCase();
        plugin.getProtectNMS().sendActionTitle(player, plugin.getLangManager().get("messages.actions." + actionKey), tooltipBody, "/spt view item " + logEntry.hashCode(), text -> text.replace("<time>", TimeUtils.formatMillisAsAgo(logEntry.getCreatedAt())).replace("<player>", PlayerUtils.getNameOfEntity(logEntry.getPlayerId())).replace("<data>", itemDetails.getCleanName()));
    }

    private static class ItemDetails {
        private final ItemStack item;
        private final int amount;
        private final String cleanName;

        ItemDetails(ItemStack item, int amount, String cleanName) {
            this.item = item;
            this.amount = amount;
            this.cleanName = cleanName;
        }

        ItemStack getItem() {
            return this.item;
        }

        int getAmount() {
            return this.amount;
        }

        String getCleanName() {
            return this.cleanName;
        }
    }
}

