/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.enums;

import io.github.insideranh.stellarprotect.config.WorldConfigType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import lombok.Generated;

public enum ActionType {
    BLOCK_BREAK(0),
    BLOCK_PLACE(1),
    BLOCK_USE(2),
    DROP_ITEM(3),
    PICKUP_ITEM(4),
    FURNACE_EXTRACT(5),
    FURNACE_PLACE(6),
    CRAFT(7),
    ENCHANT(21),
    CROP_GROW(8),
    KILL_ENTITY(9),
    INTERACT(10),
    TAME(11),
    BREED(12),
    CHAT(13, false),
    COMMAND(14, false),
    BUCKET_EMPTY(15),
    BUCKET_FILL(16),
    INVENTORY_TRANSACTION(17),
    USE(18),
    SESSION(19),
    SIGN_CHANGE(20),
    DEATH(23),
    MOUNT(24),
    RAID(25),
    HANGING(26),
    SMITH(27),
    BREWING(28),
    REPAIR(29),
    SHOOT(30),
    TOTEM(31),
    TELEPORT(32),
    CONSUME(33),
    GAME_MODE(34),
    XP(35),
    MONEY(36),
    DECORATIVE_ITEM_CHANGE(37),
    PLACE_ITEM(38),
    REMOVE_ITEM(39),
    TREE_GROW(40),
    BLOCK_SPREAD(41),
    ARMOR_STAND_MANIPULATE(42),
    SHOP_GUI(80),
    FURNITURE_BREAK(81, false),
    FURNITURE_PLACE(82, false),
    X_KIT_EVENT(83, false);

    private static final ActionType[] ID_TO_ACTION_CACHE;
    private static final Map<String, ActionType> NAME_TO_ACTION_CACHE;
    private static final Map<String, String> WORLD_LOWER_CACHE;
    private final int id;
    private final HashMap<String, WorldConfigType> worldTypes = new HashMap();
    private final Set<String> worlds = new HashSet<String>();
    private final Set<String> disabledTypes = new HashSet<String>();
    private boolean hasAllWorlds = false;
    private boolean hasDisableAll = false;
    private boolean hasNoDisabledTypes = false;
    private boolean enabled = true;
    private boolean parseMinecraftData = true;

    private ActionType(int id) {
        this.id = id;
    }

    private ActionType(int id, boolean parseMinecraftData) {
        this.id = id;
        this.parseMinecraftData = parseMinecraftData;
    }

    private static String getLowerCaseWorld(String world) {
        if (world == null) {
            return null;
        }
        return WORLD_LOWER_CACHE.computeIfAbsent(world, String::toLowerCase);
    }

    public static ActionType getById(int id) {
        if (id >= 0 && id < ID_TO_ACTION_CACHE.length) {
            return ID_TO_ACTION_CACHE[id];
        }
        return null;
    }

    public static ActionType getByName(String name) {
        return NAME_TO_ACTION_CACHE.get(name.toLowerCase());
    }

    public static List<String> getAllNamesNoPrefix(@Nullable String filter) {
        ArrayList<String> names = new ArrayList<String>();
        for (ActionType actionType : ActionType.values()) {
            String name = actionType.name().toLowerCase();
            if (filter != null && !name.contains(filter)) continue;
            names.add(name);
        }
        return names;
    }

    public static List<String> getAllNames(@Nullable String filter) {
        ArrayList<String> names = new ArrayList<String>();
        for (ActionType actionType : ActionType.values()) {
            String name = "a:" + actionType.name().toLowerCase();
            if (filter != null && !name.contains(filter)) continue;
            names.add(name);
        }
        return names;
    }

    public boolean shouldSkipLog(String world, String type) {
        if (!this.enabled) {
            return true;
        }
        String typeLower = type.toLowerCase();
        WorldConfigType worldConfig = this.worldTypes.get(world);
        if (worldConfig != null) {
            if (!worldConfig.isEnabled()) {
                return true;
            }
            if (worldConfig.isHasNoDisabledTypes()) {
                return false;
            }
            if (worldConfig.isDisableAll()) {
                return true;
            }
            return worldConfig.getDisabledTypes().contains(typeLower);
        }
        if (this.hasNoDisabledTypes || this.hasAllWorlds) {
            return false;
        }
        if (this.hasDisableAll || this.disabledTypes.contains(typeLower)) {
            return true;
        }
        String worldLower = ActionType.getLowerCaseWorld(world);
        return worldLower != null && !this.worlds.contains(worldLower);
    }

    public boolean shouldSkipLogStart(@Nullable String world, String type) {
        if (!this.enabled) {
            return true;
        }
        String typeLower = type.toLowerCase();
        WorldConfigType worldConfig = this.worldTypes.get(world);
        if (worldConfig != null) {
            if (!worldConfig.isEnabled()) {
                return true;
            }
            if (worldConfig.isHasNoDisabledTypes()) {
                return false;
            }
            if (worldConfig.isDisableAll()) {
                return true;
            }
            for (String disabledType : worldConfig.getDisabledTypes()) {
                if (!typeLower.startsWith(disabledType)) continue;
                return true;
            }
            return false;
        }
        if (this.hasNoDisabledTypes || this.hasAllWorlds) {
            return false;
        }
        if (this.hasDisableAll) {
            return true;
        }
        for (String disabledType : this.disabledTypes) {
            if (!typeLower.startsWith(disabledType)) continue;
            return true;
        }
        if (world == null) {
            return true;
        }
        String worldLower = ActionType.getLowerCaseWorld(world);
        return !this.worlds.contains(worldLower);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public HashMap<String, WorldConfigType> getWorldTypes() {
        return this.worldTypes;
    }

    @Generated
    public Set<String> getWorlds() {
        return this.worlds;
    }

    @Generated
    public Set<String> getDisabledTypes() {
        return this.disabledTypes;
    }

    @Generated
    public boolean isHasAllWorlds() {
        return this.hasAllWorlds;
    }

    @Generated
    public boolean isHasDisableAll() {
        return this.hasDisableAll;
    }

    @Generated
    public boolean isHasNoDisabledTypes() {
        return this.hasNoDisabledTypes;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isParseMinecraftData() {
        return this.parseMinecraftData;
    }

    @Generated
    public void setHasAllWorlds(boolean hasAllWorlds) {
        this.hasAllWorlds = hasAllWorlds;
    }

    @Generated
    public void setHasDisableAll(boolean hasDisableAll) {
        this.hasDisableAll = hasDisableAll;
    }

    @Generated
    public void setHasNoDisabledTypes(boolean hasNoDisabledTypes) {
        this.hasNoDisabledTypes = hasNoDisabledTypes;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        NAME_TO_ACTION_CACHE = new HashMap<String, ActionType>();
        WORLD_LOWER_CACHE = new ConcurrentHashMap<String, String>();
        int maxId = Arrays.stream(ActionType.values()).mapToInt(ActionType::getId).max().orElse(0);
        ID_TO_ACTION_CACHE = new ActionType[maxId + 1];
        ActionType[] actionTypeArray = ActionType.values();
        int n = actionTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ActionType actionType;
            ActionType.ID_TO_ACTION_CACHE[actionType.getId()] = actionType = actionTypeArray[i];
            NAME_TO_ACTION_CACHE.put(actionType.name().toLowerCase(), actionType);
        }
    }
}

