/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerSessionEntry
extends LogEntry {
    private final byte login;
    private final long sessionTime;

    public PlayerSessionEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.login = jsonObject.get("s").getAsByte();
        this.sessionTime = jsonObject.has("t") ? jsonObject.get("t").getAsLong() : 0L;
    }

    public PlayerSessionEntry(long playerId, Location location, byte login, long sessionTime) {
        super(playerId, ActionType.SESSION.getId(), location, System.currentTimeMillis());
        this.login = login;
        this.sessionTime = sessionTime;
    }

    @Override
    public String getDataString() {
        return String.valueOf(this.login);
    }

    @Override
    public String toSaveJson() {
        if (this.sessionTime != 0L) {
            return "{\"s\":" + this.login + ",\"t\":" + this.sessionTime + "}";
        }
        return "{\"s\":" + this.login + "}";
    }

    @Generated
    public byte getLogin() {
        return this.login;
    }

    @Generated
    public long getSessionTime() {
        return this.sessionTime;
    }
}

