/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.utils;

import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public final class LocationUtils {
    public static String getStringLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (location.getWorld() == null) {
            return null;
        }
        return location.getWorld().getName() + ";" + location.getX() + ";" + location.getY() + ";" + location.getZ();
    }

    public static String getFormattedStringLocation(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (location.getWorld() == null) {
            return "";
        }
        return "x" + location.getBlockX() + "/y" + location.getBlockY() + "/z" + location.getBlockZ() + "/" + location.getWorld().getName();
    }

    public static Location getLocationString(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        String[] split = location.split(";");
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            return null;
        }
        return new Location(world, Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
    }

    @Generated
    private LocationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

