/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

import java.util.Collection;

public final class StringHashSet {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private String[] keys;
    private byte[] distances;
    private int size;
    private int threshold;
    private int mask;

    public StringHashSet(int initialCapacity) {
        int capacity = Integer.highestOneBit(initialCapacity - 1) << 1;
        if (capacity < 16) {
            capacity = 16;
        }
        this.keys = new String[capacity];
        this.distances = new byte[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static int hash(String key) {
        int h = key.hashCode();
        h ^= h >>> 16;
        return h;
    }

    public boolean add(String key) {
        if (key == null) {
            return false;
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int hash = StringHashSet.hash(key);
        int idx = hash & this.mask;
        String insertKey = key;
        byte insertDistance = 0;
        while (true) {
            if (this.keys[idx] == null) {
                this.keys[idx] = insertKey;
                this.distances[idx] = insertDistance;
                ++this.size;
                return true;
            }
            if (this.keys[idx].equals(insertKey)) {
                return false;
            }
            if (insertDistance > this.distances[idx]) {
                String tempKey = this.keys[idx];
                byte tempDistance = this.distances[idx];
                this.keys[idx] = insertKey;
                this.distances[idx] = insertDistance;
                insertKey = tempKey;
                insertDistance = tempDistance;
            }
            idx = idx + 1 & this.mask;
            insertDistance = (byte)(insertDistance + 1);
        }
    }

    public boolean contains(String key) {
        if (key == null) {
            return false;
        }
        int hash = StringHashSet.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (this.keys[idx].equals(key)) {
                return true;
            }
            idx = idx + 1 & this.mask;
        }
        return false;
    }

    public boolean remove(String key) {
        if (key == null) {
            return false;
        }
        int hash = StringHashSet.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (this.keys[idx].equals(key)) {
                int nextIdx = idx + 1 & this.mask;
                while (this.keys[nextIdx] != null && this.distances[nextIdx] > 0) {
                    this.keys[idx] = this.keys[nextIdx];
                    this.distances[idx] = (byte)(this.distances[nextIdx] - 1);
                    idx = nextIdx;
                    nextIdx = nextIdx + 1 & this.mask;
                }
                this.keys[idx] = null;
                this.distances[idx] = 0;
                --this.size;
                return true;
            }
            idx = idx + 1 & this.mask;
        }
        return false;
    }

    private void resize() {
        String[] oldKeys = this.keys;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new String[newCapacity];
        this.distances = new byte[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldKeys[i] == null) continue;
            this.add(oldKeys[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.distances[i] = 0;
        }
        this.size = 0;
    }

    public void addAll(String[] elements) {
        for (String element : elements) {
            this.add(element);
        }
    }

    public void addAll(Collection<String> elements) {
        for (String element : elements) {
            this.add(element);
        }
    }

    public void addAll(StringHashSet other) {
        for (int i = 0; i < other.keys.length; ++i) {
            if (other.keys[i] == null) continue;
            this.add(other.keys[i]);
        }
    }
}

