/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

public class StringBooleanMap {
    private static final int DEFAULT_CAPACITY = 32;
    private static final float LOAD_FACTOR = 0.75f;
    private String[] keys;
    private boolean[] values;
    private byte[] distances;
    private int size;
    private int threshold;
    private int mask;

    public StringBooleanMap() {
        int capacity = 32;
        this.keys = new String[capacity];
        this.values = new boolean[capacity];
        this.distances = new byte[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static int hash(String key) {
        int h = key.hashCode();
        return h ^ h >>> 16;
    }

    public boolean get(String key) {
        if (key == null) {
            return false;
        }
        int hash = StringBooleanMap.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (this.keys[idx].equals(key)) {
                return this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return false;
    }

    public void put(String key, boolean value) {
        if (key == null) {
            return;
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int hash = StringBooleanMap.hash(key);
        int idx = hash & this.mask;
        String insertKey = key;
        boolean insertValue = value;
        byte insertDistance = 0;
        while (true) {
            if (this.keys[idx] == null) {
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                ++this.size;
                return;
            }
            if (this.keys[idx].equals(insertKey)) {
                this.values[idx] = insertValue;
                return;
            }
            if (insertDistance > this.distances[idx]) {
                String tempKey = this.keys[idx];
                boolean tempValue = this.values[idx];
                byte tempDistance = this.distances[idx];
                this.keys[idx] = insertKey;
                this.values[idx] = insertValue;
                this.distances[idx] = insertDistance;
                insertKey = tempKey;
                insertValue = tempValue;
                insertDistance = tempDistance;
            }
            idx = idx + 1 & this.mask;
            insertDistance = (byte)(insertDistance + 1);
        }
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        int hash = StringBooleanMap.hash(key);
        int idx = hash & this.mask;
        for (byte distance = 0; this.keys[idx] != null && distance <= this.distances[idx]; distance = (byte)(distance + 1)) {
            if (this.keys[idx].equals(key)) {
                int nextIdx = idx + 1 & this.mask;
                while (this.keys[nextIdx] != null && this.distances[nextIdx] > 0) {
                    this.keys[idx] = this.keys[nextIdx];
                    this.values[idx] = this.values[nextIdx];
                    this.distances[idx] = (byte)(this.distances[nextIdx] - 1);
                    idx = nextIdx;
                    nextIdx = nextIdx + 1 & this.mask;
                }
                this.keys[idx] = null;
                this.values[idx] = false;
                this.distances[idx] = 0;
                --this.size;
                return;
            }
            idx = idx + 1 & this.mask;
        }
    }

    private void resize() {
        String[] oldKeys = this.keys;
        boolean[] oldValues = this.values;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new String[newCapacity];
        this.values = new boolean[newCapacity];
        this.distances = new byte[newCapacity];
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldKeys[i] == null) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }
}

