/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.validator;

import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Arrays;
import java.util.List;

public final class ReplacingDocumentFieldNameValidator
implements FieldNameValidator {
    public static final ReplacingDocumentFieldNameValidator INSTANCE = new ReplacingDocumentFieldNameValidator();
    private static final List<String> EXCEPTIONS = Arrays.asList("$db", "$ref", "$id");

    private ReplacingDocumentFieldNameValidator() {
    }

    @Override
    public boolean validate(String fieldName) {
        return !fieldName.startsWith("$") || EXCEPTIONS.contains(fieldName);
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(this.validate(fieldName));
        return String.format("Field names in a replacement document can not start with '$' but '%s' does", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return NoOpFieldNameValidator.INSTANCE;
    }
}

