/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonJavaScript;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonDocumentCodec;
import io.github.insideranh.stellarprotect.libs.mongodb.ExplainVerbosity;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.WriteConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AsyncWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.WriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CommandHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AsyncWriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.DocumentHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ExplainHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.MapReduceHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.MapReduceStatistics;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.WriteOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;

public class MapReduceToCollectionOperation
implements AsyncWriteOperation<MapReduceStatistics>,
WriteOperation<MapReduceStatistics> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private String action = "replace";
    private String databaseName;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private static final List<String> VALID_ACTIONS = Arrays.asList("replace", "merge", "reduce");

    public MapReduceToCollectionOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, @Nullable String collectionName, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.writeConcern = writeConcern;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceToCollectionOperation finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceToCollectionOperation scope(@Nullable BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceToCollectionOperation filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceToCollectionOperation sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceToCollectionOperation limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceToCollectionOperation jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceToCollectionOperation verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public MapReduceToCollectionOperation action(String action) {
        Assertions.notNull("action", action);
        Assertions.isTrue("action must be one of: \"replace\", \"merge\", \"reduce\"", VALID_ACTIONS.contains(action));
        this.action = action;
        return this;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public MapReduceToCollectionOperation databaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MapReduceToCollectionOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MapReduceStatistics execute(WriteBinding binding) {
        return SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.transformer(binding.getOperationContext().getTimeoutContext()));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<MapReduceStatistics> callback) {
        AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.transformerAsync(binding.getOperationContext().getTimeoutContext()), callback);
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, explainVerbosity);
        }, new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandWriteTransformer<BsonDocument, MapReduceStatistics> transformer(TimeoutContext timeoutContext) {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return MapReduceHelper.createStatistics(result);
        };
    }

    private AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, MapReduceStatistics> transformerAsync(TimeoutContext timeoutContext) {
        return (result, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(result, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return MapReduceHelper.createStatistics(result);
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument outputDocument = new BsonDocument(this.getAction(), new BsonString(this.getCollectionName()));
            if (this.getDatabaseName() != null) {
                outputDocument.put("db", new BsonString(this.getDatabaseName()));
            }
            BsonDocument commandDocument = new BsonDocument("mapReduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", outputDocument);
            DocumentHelper.putIfNotNull(commandDocument, "query", this.getFilter());
            DocumentHelper.putIfNotNull(commandDocument, "sort", this.getSort());
            DocumentHelper.putIfNotNull(commandDocument, "finalize", this.getFinalizeFunction());
            DocumentHelper.putIfNotNull(commandDocument, "scope", this.getScope());
            DocumentHelper.putIfTrue(commandDocument, "verbose", this.isVerbose());
            DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
            DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
            if (this.bypassDocumentValidation != null) {
                commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
            }
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
            if (this.collation != null) {
                commandDocument.put("collation", this.collation.asDocument());
            }
            return commandDocument;
        };
    }
}

