/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.SearchIndexType;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SearchIndexRequest;
import java.util.List;
import java.util.stream.Collectors;

public final class CreateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "createSearchIndexes";
    private final List<SearchIndexRequest> indexRequests;

    public CreateSearchIndexesOperation(MongoNamespace namespace, List<SearchIndexRequest> indexRequests) {
        super(namespace);
        this.indexRequests = Assertions.assertNotNull(indexRequests);
    }

    private static BsonArray convert(List<SearchIndexRequest> requests) {
        return requests.stream().map(CreateSearchIndexesOperation::convert).collect(Collectors.toCollection(BsonArray::new));
    }

    private static BsonDocument convert(SearchIndexRequest request) {
        SearchIndexType searchIndexType;
        BsonDocument bsonIndexRequest = new BsonDocument();
        String searchIndexName = request.getIndexName();
        if (searchIndexName != null) {
            bsonIndexRequest.append("name", new BsonString(searchIndexName));
        }
        if ((searchIndexType = request.getSearchIndexType()) != null) {
            bsonIndexRequest.append("type", searchIndexType.toBsonValue());
        }
        bsonIndexRequest.append("definition", request.getDefinition());
        return bsonIndexRequest;
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("indexes", CreateSearchIndexesOperation.convert(this.indexRequests));
    }
}

