/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.operation;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt32;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCommandException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoCursorNotFoundException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoQueryException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.CommandCursorResult;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.DocumentHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.OperationHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ServerVersionHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.Collections;

final class CommandBatchCursorHelper {
    static final String FIRST_BATCH = "firstBatch";
    static final String NEXT_BATCH = "nextBatch";
    static final String MESSAGE_IF_CLOSED_AS_CURSOR = "Cursor has been closed";
    static final String MESSAGE_IF_CLOSED_AS_ITERATOR = "Iterator has been closed";
    static final String MESSAGE_IF_CONCURRENT_OPERATION = "Another operation is currently in progress, concurrent operations are not supported";

    static BsonDocument getMoreCommandDocument(long cursorId, ConnectionDescription connectionDescription, MongoNamespace namespace, int batchSize, @Nullable BsonValue comment) {
        BsonDocument document = new BsonDocument("getMore", new BsonInt64(cursorId)).append("collection", new BsonString(namespace.getCollectionName()));
        if (batchSize != 0) {
            document.append("batchSize", new BsonInt32(batchSize));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(document, "comment", comment);
        }
        return document;
    }

    static <T> CommandCursorResult<T> logCommandCursorResult(CommandCursorResult<T> commandCursorResult) {
        if (OperationHelper.LOGGER.isDebugEnabled()) {
            OperationHelper.LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", commandCursorResult.getResults().size(), commandCursorResult.getCursorId(), commandCursorResult.getServerAddress()));
        }
        return commandCursorResult;
    }

    static BsonDocument getKillCursorsCommand(MongoNamespace namespace, ServerCursor serverCursor) {
        return new BsonDocument("killCursors", new BsonString(namespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(serverCursor.getId()))));
    }

    static MongoQueryException translateCommandException(MongoCommandException commandException, ServerCursor cursor) {
        if (commandException.getErrorCode() == 43) {
            return new MongoCursorNotFoundException(cursor.getId(), commandException.getResponse(), cursor.getAddress());
        }
        return new MongoQueryException(commandException.getResponse(), commandException.getServerAddress());
    }

    private CommandBatchCursorHelper() {
    }
}

