/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoException;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterId;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterType;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.AbstractMultiServerCluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ClusterableServerFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DnsSrvRecordInitializer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DnsSrvRecordMonitor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public final class DnsMultiServerCluster
extends AbstractMultiServerCluster {
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;

    public DnsMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        super(clusterId, settings, serverFactory);
        this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(Assertions.assertNotNull(settings.getSrvHost()), settings.getSrvServiceName(), new DnsSrvRecordInitializer(){
            private volatile boolean initialized;

            @Override
            public void initialize(Collection<ServerAddress> hosts) {
                DnsMultiServerCluster.this.srvResolutionException = null;
                if (!this.initialized) {
                    this.initialized = true;
                    DnsMultiServerCluster.this.initialize(this.applySrvMaxHosts(hosts));
                } else {
                    DnsMultiServerCluster.this.onChange(this.applySrvMaxHosts(hosts));
                }
            }

            private Collection<ServerAddress> applySrvMaxHosts(Collection<ServerAddress> latestSrvHosts) {
                Integer srvMaxHosts = DnsMultiServerCluster.this.getSettings().getSrvMaxHosts();
                if (srvMaxHosts == null || srvMaxHosts <= 0 || latestSrvHosts.size() <= srvMaxHosts) {
                    return new ArrayList<ServerAddress>(latestSrvHosts);
                }
                List<ServerAddress> activeHosts = this.getActivePriorHosts(latestSrvHosts);
                int numNewHostsToAdd = srvMaxHosts - activeHosts.size();
                activeHosts.addAll(this.addShuffledHosts(latestSrvHosts, activeHosts, numNewHostsToAdd));
                return activeHosts;
            }

            private List<ServerAddress> getActivePriorHosts(Collection<ServerAddress> latestSrvHosts) {
                List<ServerAddress> priorHosts = DnsMultiServerCluster.this.getCurrentDescription().getServerDescriptions().stream().map(ServerDescription::getAddress).collect(Collectors.toList());
                priorHosts.removeIf(host -> !latestSrvHosts.contains(host));
                return priorHosts;
            }

            private List<ServerAddress> addShuffledHosts(Collection<ServerAddress> latestSrvHosts, List<ServerAddress> activePriorHosts, int numNewHostsToAdd) {
                ArrayList<ServerAddress> addedHosts = new ArrayList<ServerAddress>(latestSrvHosts);
                addedHosts.removeAll(activePriorHosts);
                Collections.shuffle(addedHosts, ThreadLocalRandom.current());
                return addedHosts.subList(0, numNewHostsToAdd);
            }

            @Override
            public void initialize(MongoException initializationException) {
                if (!this.initialized) {
                    DnsMultiServerCluster.this.srvResolutionException = initializationException;
                    DnsMultiServerCluster.this.initialize(Collections.emptyList());
                }
            }

            @Override
            public ClusterType getClusterType() {
                return DnsMultiServerCluster.this.getClusterType();
            }
        });
        this.dnsSrvRecordMonitor.start();
    }

    @Override
    @Nullable
    protected MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    @Override
    public void close() {
        if (this.dnsSrvRecordMonitor != null) {
            this.dnsSrvRecordMonitor.close();
        }
        super.close();
    }
}

