/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonArray;
import io.github.insideranh.stellarprotect.libs.bson.BsonBinaryWriter;
import io.github.insideranh.stellarprotect.libs.bson.BsonBoolean;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonElement;
import io.github.insideranh.stellarprotect.libs.bson.BsonInt64;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.ByteBuf;
import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoInternalException;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerApi;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ClusterConnectionMode;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerType;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.BsonWriterHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ByteBufBsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ByteBufferBsonOutput;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CompositeByteBuf;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.DualMessageSequences;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageSequences;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OpCode;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ReadConcernHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.RequestMessage;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.SplittablePayload;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.session.SessionContext;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class CommandMessage
extends RequestMessage {
    private static final byte PAYLOAD_TYPE_0_DOCUMENT = 0;
    private static final byte PAYLOAD_TYPE_1_DOCUMENT_SEQUENCE = 1;
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final FieldNameValidator commandFieldNameValidator;
    private final ReadPreference readPreference;
    private final boolean exhaustAllowed;
    private final MessageSequences sequences;
    private final boolean responseExpected;
    @Nullable
    private Boolean dualMessageSequencesRequireResponse;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, true, MessageSequences.EmptyMessageSequences.INSTANCE, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean exhaustAllowed, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, true, exhaustAllowed, MessageSequences.EmptyMessageSequences.INSTANCE, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean responseExpected, MessageSequences sequences, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, responseExpected, false, sequences, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean responseExpected, boolean exhaustAllowed, MessageSequences sequences, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(namespace.getFullName(), CommandMessage.getOpCode(settings, clusterConnectionMode, serverApi), settings);
        this.namespace = namespace;
        this.command = command;
        this.commandFieldNameValidator = commandFieldNameValidator;
        this.readPreference = readPreference;
        this.responseExpected = responseExpected;
        this.dualMessageSequencesRequireResponse = null;
        this.exhaustAllowed = exhaustAllowed;
        this.sequences = sequences;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        Assertions.assertTrue(this.useOpMsg() || responseExpected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonDocument getCommandDocument(ByteBufferBsonOutput bsonOutput) {
        List<ByteBuf> byteBuffers = bsonOutput.getByteBuffers();
        try {
            ByteBufBsonDocument byteBufBsonDocument;
            CompositeByteBuf byteBuf;
            block12: {
                byteBuf = new CompositeByteBuf(byteBuffers);
                try {
                    byteBuf.position(this.getEncodingMetadata().getFirstDocumentPosition());
                    byteBufBsonDocument = ByteBufBsonDocument.createOne(byteBuf);
                    if (!byteBuf.hasRemaining()) break block12;
                    BsonDocument commandBsonDocument = byteBufBsonDocument.toBaseBsonDocument();
                    while (byteBuf.hasRemaining()) {
                        byteBuf.position(byteBuf.position() + 1);
                        int sequenceStart = byteBuf.position();
                        int sequenceSizeInBytes = byteBuf.getInt();
                        int sectionEnd = sequenceStart + sequenceSizeInBytes;
                        String fieldName = this.getSequenceIdentifier(byteBuf);
                        Assertions.assertFalse(fieldName.contains("."));
                        ByteBuf documentsByteBufSlice = byteBuf.duplicate().limit(sectionEnd);
                        try {
                            commandBsonDocument.append(fieldName, new BsonArray(ByteBufBsonDocument.createList(documentsByteBufSlice)));
                        }
                        finally {
                            documentsByteBufSlice.release();
                        }
                        byteBuf.position(sectionEnd);
                    }
                    BsonDocument bsonDocument = commandBsonDocument;
                    byteBuf.release();
                    return bsonDocument;
                }
                catch (Throwable throwable) {
                    byteBuf.release();
                    throw throwable;
                }
            }
            ByteBufBsonDocument byteBufBsonDocument2 = byteBufBsonDocument;
            byteBuf.release();
            return byteBufBsonDocument2;
        }
        finally {
            byteBuffers.forEach(ByteBuf::release);
        }
    }

    private String getSequenceIdentifier(ByteBuf byteBuf) {
        ByteArrayOutputStream sequenceIdentifierBytes = new ByteArrayOutputStream();
        byte curByte = byteBuf.get();
        while (curByte != 0) {
            sequenceIdentifierBytes.write(curByte);
            curByte = byteBuf.get();
        }
        try {
            return sequenceIdentifierBytes.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MongoInternalException("Unexpected exception", e);
        }
    }

    boolean isResponseExpected() {
        if (this.responseExpected) {
            return true;
        }
        if (this.sequences instanceof SplittablePayload) {
            SplittablePayload payload = (SplittablePayload)this.sequences;
            return payload.isOrdered() && payload.hasAnotherSplit();
        }
        if (this.sequences instanceof DualMessageSequences) {
            return Assertions.assertNotNull(this.dualMessageSequencesRequireResponse);
        }
        if (!(this.sequences instanceof MessageSequences.EmptyMessageSequences)) {
            Assertions.fail(this.sequences.toString());
        }
        return false;
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(ByteBufferBsonOutput bsonOutput, OperationContext operationContext) {
        int commandStartPosition = this.useOpMsg() ? this.writeOpMsg(bsonOutput, operationContext) : this.writeOpQuery(bsonOutput);
        return new RequestMessage.EncodingMetadata(commandStartPosition);
    }

    private int writeOpMsg(ByteBufferBsonOutput bsonOutput, OperationContext operationContext) {
        int commandStartPosition;
        int flagPosition;
        block35: {
            int messageStartPosition = bsonOutput.getPosition() - 16;
            flagPosition = bsonOutput.getPosition();
            bsonOutput.writeInt32(0);
            bsonOutput.writeByte(0);
            commandStartPosition = bsonOutput.getPosition();
            List<BsonElement> extraElements = this.getExtraElements(operationContext);
            int commandDocumentSizeInBytes = this.writeDocument(this.command, bsonOutput, this.commandFieldNameValidator);
            if (this.sequences instanceof SplittablePayload) {
                BsonWriterHelper.appendElementsToDocument(bsonOutput, commandStartPosition, extraElements);
                SplittablePayload payload = (SplittablePayload)this.sequences;
                try (FinishOpMsgSectionWithPayloadType1 finishSection = this.startOpMsgSectionWithPayloadType1(bsonOutput, payload.getPayloadName());){
                    BsonWriterHelper.writePayload(new BsonBinaryWriter(bsonOutput, payload.getFieldNameValidator()), bsonOutput, this.getSettings(), messageStartPosition, payload, this.getSettings().getMaxDocumentSize());
                }
            }
            if (this.sequences instanceof DualMessageSequences) {
                DualMessageSequences dualMessageSequences = (DualMessageSequences)this.sequences;
                try (ByteBufferBsonOutput.Branch bsonOutputBranch2 = bsonOutput.branch();
                     ByteBufferBsonOutput.Branch bsonOutputBranch1 = bsonOutput.branch();){
                    DualMessageSequences.EncodeDocumentsResult encodeDocumentsResult;
                    try (FinishOpMsgSectionWithPayloadType1 finishSection1 = this.startOpMsgSectionWithPayloadType1(bsonOutputBranch1, dualMessageSequences.getFirstSequenceId());
                         FinishOpMsgSectionWithPayloadType1 finishSection2 = this.startOpMsgSectionWithPayloadType1(bsonOutputBranch2, dualMessageSequences.getSecondSequenceId());){
                        encodeDocumentsResult = BsonWriterHelper.writeDocumentsOfDualMessageSequences(dualMessageSequences, commandDocumentSizeInBytes, bsonOutputBranch1, bsonOutputBranch2, this.getSettings());
                    }
                    this.dualMessageSequencesRequireResponse = encodeDocumentsResult.isServerResponseRequired();
                    extraElements.addAll(encodeDocumentsResult.getExtraElements());
                    BsonWriterHelper.appendElementsToDocument(bsonOutput, commandStartPosition, extraElements);
                    break block35;
                }
            }
            if (this.sequences instanceof MessageSequences.EmptyMessageSequences) {
                BsonWriterHelper.appendElementsToDocument(bsonOutput, commandStartPosition, extraElements);
            } else {
                Assertions.fail(this.sequences.toString());
            }
        }
        bsonOutput.writeInt32(flagPosition, this.getOpMsgFlagBits());
        return commandStartPosition;
    }

    private int writeOpQuery(ByteBufferBsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.namespace.getFullName());
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(-1);
        int commandStartPosition = bsonOutput.getPosition();
        ArrayList<BsonElement> elements = null;
        if (this.serverApi != null) {
            elements = new ArrayList<BsonElement>(3);
            this.addServerApiElements(elements);
        }
        this.writeDocument(this.command, bsonOutput, this.commandFieldNameValidator);
        BsonWriterHelper.appendElementsToDocument(bsonOutput, commandStartPosition, elements);
        return commandStartPosition;
    }

    private int getOpMsgFlagBits() {
        int flagBits = 0;
        if (!this.isResponseExpected()) {
            flagBits = 2;
        }
        if (this.exhaustAllowed) {
            flagBits |= 0x10000;
        }
        return flagBits;
    }

    private boolean isDirectConnectionToReplicaSetMember() {
        return this.clusterConnectionMode == ClusterConnectionMode.SINGLE && this.getSettings().getServerType() != ServerType.SHARD_ROUTER && this.getSettings().getServerType() != ServerType.STANDALONE;
    }

    private boolean useOpMsg() {
        return this.getOpCode().equals((Object)OpCode.OP_MSG);
    }

    private List<BsonElement> getExtraElements(OperationContext operationContext) {
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        ArrayList<BsonElement> extraElements = new ArrayList<BsonElement>();
        if (!this.getSettings().isCryptd()) {
            timeoutContext.runMaxTimeMS(maxTimeMS -> extraElements.add(new BsonElement("maxTimeMS", new BsonInt64(maxTimeMS))));
        }
        extraElements.add(new BsonElement("$db", new BsonString(new MongoNamespace(this.getCollectionName()).getDatabaseName())));
        if (sessionContext.getClusterTime() != null) {
            extraElements.add(new BsonElement("$clusterTime", sessionContext.getClusterTime()));
        }
        if (sessionContext.hasSession()) {
            if (!sessionContext.isImplicitSession() && !this.getSettings().isSessionSupported()) {
                throw new MongoClientException("Attempting to use a ClientSession while connected to a server that doesn't support sessions");
            }
            if (this.getSettings().isSessionSupported() && this.responseExpected) {
                extraElements.add(new BsonElement("lsid", sessionContext.getSessionId()));
            }
        }
        boolean firstMessageInTransaction = sessionContext.notifyMessageSent();
        Assertions.assertFalse(sessionContext.hasActiveTransaction() && sessionContext.isSnapshot());
        if (sessionContext.hasActiveTransaction()) {
            extraElements.add(new BsonElement("txnNumber", new BsonInt64(sessionContext.getTransactionNumber())));
            if (firstMessageInTransaction) {
                extraElements.add(new BsonElement("startTransaction", BsonBoolean.TRUE));
                this.addReadConcernDocument(extraElements, sessionContext);
            }
            extraElements.add(new BsonElement("autocommit", BsonBoolean.FALSE));
        } else if (sessionContext.isSnapshot()) {
            this.addReadConcernDocument(extraElements, sessionContext);
        }
        if (this.serverApi != null) {
            this.addServerApiElements(extraElements);
        }
        if (this.readPreference != null) {
            if (!this.readPreference.equals(ReadPreference.primary())) {
                extraElements.add(new BsonElement("$readPreference", this.readPreference.toDocument()));
            } else if (this.isDirectConnectionToReplicaSetMember()) {
                extraElements.add(new BsonElement("$readPreference", ReadPreference.primaryPreferred().toDocument()));
            }
        }
        return extraElements;
    }

    private void addServerApiElements(List<BsonElement> extraElements) {
        extraElements.add(new BsonElement("apiVersion", new BsonString(this.serverApi.getVersion().getValue())));
        if (this.serverApi.getStrict().isPresent()) {
            extraElements.add(new BsonElement("apiStrict", BsonBoolean.valueOf(this.serverApi.getStrict().get())));
        }
        if (this.serverApi.getDeprecationErrors().isPresent()) {
            extraElements.add(new BsonElement("apiDeprecationErrors", BsonBoolean.valueOf(this.serverApi.getDeprecationErrors().get())));
        }
    }

    private void addReadConcernDocument(List<BsonElement> extraElements, SessionContext sessionContext) {
        BsonDocument readConcernDocument = ReadConcernHelper.getReadConcernDocument(sessionContext, this.getSettings().getMaxWireVersion());
        if (!readConcernDocument.isEmpty()) {
            extraElements.add(new BsonElement("readConcern", readConcernDocument));
        }
    }

    private FinishOpMsgSectionWithPayloadType1 startOpMsgSectionWithPayloadType1(ByteBufferBsonOutput bsonOutput, String sequenceId) {
        bsonOutput.writeByte(1);
        int sequenceStart = bsonOutput.getPosition();
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(sequenceId);
        return () -> BsonWriterHelper.backpatchLength(sequenceStart, bsonOutput);
    }

    private static OpCode getOpCode(MessageSettings settings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return CommandMessage.isServerVersionKnown(settings) || clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED || serverApi != null ? OpCode.OP_MSG : OpCode.OP_QUERY;
    }

    private static boolean isServerVersionKnown(MessageSettings settings) {
        return settings.getMaxWireVersion() != 0;
    }

    @FunctionalInterface
    private static interface FinishOpMsgSectionWithPayloadType1
    extends AutoCloseable {
        @Override
        public void close();
    }
}

