/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.authentication;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientException;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.NonNull;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

final class HttpHelper {
    private HttpHelper() {
    }

    @NonNull
    public static String getHttpContents(String method, String endpoint, @Nullable Map<String, String> headers) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            int status;
            conn = (HttpURLConnection)new URL(endpoint).openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestMethod(method);
            if (headers != null) {
                for (Map.Entry<String, String> kvp : headers.entrySet()) {
                    conn.setRequestProperty(kvp.getKey(), kvp.getValue());
                }
            }
            if ((status = conn.getResponseCode()) != 200) {
                throw new IOException(String.format("%d %s", status, conn.getResponseMessage()));
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new MongoClientException("Unexpected IOException from endpoint " + endpoint + ".", e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return content.toString();
    }
}

