/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function;

import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.MutableValue;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;

@FunctionalInterface
public interface AsyncCallbackSupplier<R> {
    public void get(SingleResultCallback<R> var1);

    default public AsyncCallbackSupplier<R> whenComplete(Runnable after) {
        MutableValue<Boolean> afterExecuted = new MutableValue<Boolean>(false);
        Runnable trackableAfter = () -> {
            try {
                after.run();
            }
            finally {
                afterExecuted.set(true);
            }
        };
        return callback -> {
            SingleResultCallback<Object> callbackThatCallsAfter = (result, t) -> {
                Throwable primaryException = t;
                try {
                    trackableAfter.run();
                }
                catch (Throwable afterException) {
                    if (primaryException == null) {
                        primaryException = afterException;
                    } else {
                        primaryException.addSuppressed(afterException);
                    }
                    callback.onResult(null, primaryException);
                    return;
                }
                callback.onResult(result, primaryException);
            };
            Throwable primaryUnexpectedException = null;
            try {
                this.get(callbackThatCallsAfter);
            }
            catch (Throwable unexpectedException) {
                primaryUnexpectedException = unexpectedException;
                throw unexpectedException;
            }
            finally {
                if (primaryUnexpectedException != null && !((Boolean)afterExecuted.get()).booleanValue()) {
                    try {
                        trackableAfter.run();
                    }
                    catch (Throwable afterException) {
                        primaryUnexpectedException.addSuppressed(afterException);
                    }
                }
            }
        };
    }
}

