/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.event;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionId;
import java.util.concurrent.TimeUnit;

public final class ServerHeartbeatSucceededEvent {
    private final ConnectionId connectionId;
    private final BsonDocument reply;
    private final long elapsedTimeNanos;
    private final boolean awaited;

    public ServerHeartbeatSucceededEvent(ConnectionId connectionId, BsonDocument reply, long elapsedTimeNanos, boolean awaited) {
        this.connectionId = Assertions.notNull("connectionId", connectionId);
        this.reply = Assertions.notNull("reply", reply);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
        this.awaited = awaited;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public BsonDocument getReply() {
        return this.reply;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public boolean isAwaited() {
        return this.awaited;
    }

    public String toString() {
        return "ServerHeartbeatSucceededEvent{connectionId=" + this.connectionId + ", server=" + this.connectionId.getServerId().getAddress() + ", clusterId=" + this.connectionId.getServerId().getClusterId() + ", reply=" + this.reply + ", elapsedTimeNanos=" + this.elapsedTimeNanos + ", awaited=" + this.awaited + "} ";
    }
}

